/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.api.bogeymenu.v0.BogeyMenuManager;
import com.railwayteam.railways.api.bogeymenu.v0.entry.CategoryEntry;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowDoubleScotchYokeBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowDoubleScotchYokeBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowScotchYokeBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowScotchYokeBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowSmallBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.narrow.NarrowSmallBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.HandcarBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.HandcarBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ArchbarBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ArchbarBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.BlombergBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.BlombergBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.FreightBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.FreightBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ModernBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.ModernBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.PassengerBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.PassengerBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.Y25BogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle.Y25BogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0100Renderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0100Visual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0120Renderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled0120Visual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled040Renderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled040Visual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled060Renderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled060Visual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled080Renderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.large.LargeCreateStyled080Visual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium10010TenderRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium10010TenderVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium202TrailingRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium202TrailingVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium404TrailingRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium404TrailingVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TenderRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TenderVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TrailingRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium606TrailingVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium808TenderRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.Medium808TenderVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuadrupleWheelRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuadrupleWheelVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuintupleWheelRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumQuintupleWheelVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumSingleWheelRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumSingleWheelVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumStandardRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumStandardVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumTripleWheelRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium.MediumTripleWheelVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.CoilspringBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.CoilspringBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.LeafspringBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.LeafspringBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.SingleaxleBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle.SingleaxleBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.HeavyweightBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.HeavyweightBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.RadialBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.standard.triple_axle.RadialBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideComicallyLargeScotchYokeBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideComicallyLargeScotchYokeBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideDefaultBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideDefaultBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideScotchYokeBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.renderer.wide.WideScotchYokeBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyVisual;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyVisual;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CRBogeyStyles {
    public static final String SINGLEAXLE_CYCLE_GROUP = "singleaxles";
    public static final String DOUBLEAXLE_CYCLE_GROUP = "doubleaxles";
    public static final String TRIPLEAXLE_CYCLE_GROUP = "tripleaxles";
    public static final String QUADRUPLEAXLE_CYCLE_GROUP = "quadrupleaxles";
    public static final String QUINTUPLEAXLE_CYCLE_GROUP = "quintupleaxles";
    public static final String SEXTUPLEAXLE_CYCLE_GROUP = "sextupleaxles";
    public static final CategoryEntry STANDARD_CATEGORY = CRBogeyStyles.registerCategory(AllBogeyStyles.STANDARD_CYCLE_GROUP);
    public static final CategoryEntry SINGLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("singleaxles");
    public static final CategoryEntry DOUBLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("doubleaxles");
    public static final CategoryEntry TRIPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("tripleaxles");
    public static final CategoryEntry QUADRUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("quadrupleaxles");
    public static final CategoryEntry QUINTUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("quintupleaxles");
    public static final CategoryEntry SEXTUPLEAXLE_CATEGORY = CRBogeyStyles.registerCategory("sextupleaxles");
    private static final Map<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle> STYLES_FOR_GAUGES = new HashMap<Pair<BogeyStyle, TrackMaterial.TrackType>, BogeyStyle>();
    private static final Map<BogeyStyle, BogeyStyle> STYLES_TO_STANDARD_GAUGE = new HashMap<BogeyStyle, BogeyStyle>();
    private static final Set<BogeyStyle> SUB_LISTED_STYLES = new HashSet<BogeyStyle>();
    private static final Map<BogeyStyle, List<BogeyStyle>> SUB_STYLES = new HashMap<BogeyStyle, List<BogeyStyle>>();
    private static final List<BogeyStyle> EMPTY = ImmutableList.of();
    public static final BogeyStyle MONOBOGEY = CRBogeyStyles.create("monobogey", "monobogey").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.monobogey")).size(BogeySizes.SMALL, CRBlocks.MONO_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MonoBogeyRenderer(), MonoBogeyVisual::new)).build();
    public static final BogeyStyle INVISIBLE = CRBogeyStyles.create("invisible", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.invisible")).size(BogeySizes.SMALL, CRBlocks.INVISIBLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new InvisibleBogeyRenderer(), InvisibleBogeyVisual::new)).contactParticle((ParticleOptions)new CubeParticleData()).build();
    public static final BogeyStyle INVISIBLE_MONOBOGEY = CRBogeyStyles.create("invisible_monobogey", "monobogey").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.invisible_monobogey")).size(BogeySizes.SMALL, CRBlocks.INVISIBLE_MONO_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new InvisibleBogeyRenderer(), InvisibleBogeyVisual::new)).contactParticle((ParticleOptions)new CubeParticleData()).build();
    public static final BogeyStyle SINGLEAXLE = CRBogeyStyles.create("singleaxle", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new SingleaxleBogeyRenderer(), SingleaxleBogeyVisual::new)).build();
    public static final BogeyStyle LEAFSPRING = CRBogeyStyles.create("leafspring", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LeafspringBogeyRenderer(), LeafspringBogeyVisual::new)).build();
    public static final BogeyStyle COILSPRING = CRBogeyStyles.create("coilspring", "singleaxles").size(BogeySizes.SMALL, CRBlocks.SINGLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new CoilspringBogeyRenderer(), CoilspringBogeyVisual::new)).build();
    public static final BogeyStyle FREIGHT = CRBogeyStyles.create("freight", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new FreightBogeyRenderer(), FreightBogeyVisual::new)).build();
    public static final BogeyStyle ARCHBAR = CRBogeyStyles.create("archbar", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new ArchbarBogeyRenderer(), ArchbarBogeyVisual::new)).build();
    public static final BogeyStyle PASSENGER = CRBogeyStyles.create("passenger", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new PassengerBogeyRenderer(), PassengerBogeyVisual::new)).build();
    public static final BogeyStyle MODERN = CRBogeyStyles.create("modern", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new ModernBogeyRenderer(), ModernBogeyVisual::new)).build();
    public static final BogeyStyle BLOMBERG = CRBogeyStyles.create("blomberg", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new BlombergBogeyRenderer(), BlombergBogeyVisual::new)).build();
    public static final BogeyStyle Y25 = CRBogeyStyles.create("y25", "doubleaxles").size(BogeySizes.SMALL, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Y25BogeyRenderer(), Y25BogeyVisual::new)).build();
    public static final BogeyStyle HEAVYWEIGHT = CRBogeyStyles.create("heavyweight", "tripleaxles").size(BogeySizes.SMALL, CRBlocks.TRIPLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new HeavyweightBogeyRenderer(), HeavyweightBogeyVisual::new)).build();
    public static final BogeyStyle RADIAL = CRBogeyStyles.create("radial", "tripleaxles").size(BogeySizes.SMALL, CRBlocks.TRIPLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new RadialBogeyRenderer(), RadialBogeyVisual::new)).build();
    public static final BogeyStyle WIDE_DEFAULT = CRBogeyStyles.create("wide_default", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.wide_default")).size(BogeySizes.SMALL, CRBlocks.WIDE_DOUBLEAXLE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new WideDefaultBogeyRenderer(), WideDefaultBogeyVisual::new)).size(BogeySizes.LARGE, CRBlocks.WIDE_SCOTCH_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new WideScotchYokeBogeyRenderer(), WideScotchYokeBogeyVisual::new)).build();
    public static final BogeyStyle WIDE_COMICALLY_LARGE = CRBogeyStyles.create("wide_comically_large", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.wide_comically_large")).size(BogeySizes.LARGE, CRBlocks.WIDE_COMICALLY_LARGE_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new WideComicallyLargeScotchYokeBogeyRenderer(), WideComicallyLargeScotchYokeBogeyVisual::new)).build();
    public static final BogeyStyle NARROW_DEFAULT = CRBogeyStyles.create("narrow_default", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.narrow_default")).size(BogeySizes.SMALL, CRBlocks.NARROW_SMALL_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new NarrowSmallBogeyRenderer(), NarrowSmallBogeyVisual::new)).size(BogeySizes.LARGE, CRBlocks.NARROW_SCOTCH_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new NarrowScotchYokeBogeyRenderer(), NarrowScotchYokeBogeyVisual::new)).build();
    public static final BogeyStyle NARROW_DOUBLE_SCOTCH = CRBogeyStyles.create("narrow_double_scotch", AllBogeyStyles.STANDARD_CYCLE_GROUP).displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.narrow_double_scotch")).size(BogeySizes.LARGE, CRBlocks.NARROW_DOUBLE_SCOTCH_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new NarrowDoubleScotchYokeBogeyRenderer(), NarrowDoubleScotchYokeBogeyVisual::new)).build();
    public static final BogeyStyle HANDCAR = CRBogeyStyles.create("handcar", "handcar_cycle_group").size(BogeySizes.SMALL, CRBlocks.HANDCAR, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new HandcarBogeyRenderer(), HandcarBogeyVisual::new)).soundEvent(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.COGS).getMainEvent()).build();
    public static final BogeyStyle MEDIUM_STANDARD = CRBogeyStyles.create("medium_standard", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_standard")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MediumStandardRenderer(), MediumStandardVisual::new)).build();
    public static final BogeyStyle MEDIUM_SINGLE_WHEEL = CRBogeyStyles.create("medium_single_wheel", "singleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_single_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_BOGEY, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MediumSingleWheelRenderer(), MediumSingleWheelVisual::new)).build();
    public static final BogeyStyle MEDIUM_TRIPLE_WHEEL = CRBogeyStyles.create("medium_triple_wheel", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_triple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MediumTripleWheelRenderer(), MediumTripleWheelVisual::new)).build();
    public static final BogeyStyle MEDIUM_QUADRUPLE_WHEEL = CRBogeyStyles.create("medium_quadruple_wheel", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_quadruple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUADRUPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MediumQuadrupleWheelRenderer(), MediumQuadrupleWheelVisual::new)).build();
    public static final BogeyStyle MEDIUM_QUINTUPLE_WHEEL = CRBogeyStyles.create("medium_quintuple_wheel", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_quintuple_wheel")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUINTUPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new MediumQuintupleWheelRenderer(), MediumQuintupleWheelVisual::new)).build();
    public static final BogeyStyle MEDIUM_2_0_2_TRAILING = CRBogeyStyles.create("medium_2_0_2_trailing", "singleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_2_0_2_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_2_0_2_TRAILING, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium202TrailingRenderer(), Medium202TrailingVisual::new)).build();
    public static final BogeyStyle MEDIUM_4_0_4_TRAILING = CRBogeyStyles.create("medium_4_0_4_trailing", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_4_0_4_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_4_0_4_TRAILING, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium404TrailingRenderer(), Medium404TrailingVisual::new)).build();
    public static final BogeyStyle MEDIUM_6_0_6_TRAILING = CRBogeyStyles.create("medium_6_0_6_trailing", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_6_0_6_trailing")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium606TrailingRenderer(), Medium606TrailingVisual::new)).build();
    public static final BogeyStyle MEDIUM_6_0_6_TENDER = CRBogeyStyles.create("medium_6_0_6_tender", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_6_0_6_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_TRIPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium606TenderRenderer(), Medium606TenderVisual::new)).build();
    public static final BogeyStyle MEDIUM_8_0_8_TENDER = CRBogeyStyles.create("medium_8_0_8_tender", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_8_0_8_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUADRUPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium808TenderRenderer(), Medium808TenderVisual::new)).build();
    public static final BogeyStyle MEDIUM_10_0_10_TENDER = CRBogeyStyles.create("medium_10_0_10_tender", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.medium_10_0_10_tender")).size(BogeySizes.SMALL, CRBlocks.MEDIUM_QUINTUPLE_WHEEL, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new Medium10010TenderRenderer(), Medium10010TenderVisual::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_4_0 = CRBogeyStyles.create("large_create_style_0_4_0", "doubleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_4_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_4_0, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LargeCreateStyled040Renderer(), LargeCreateStyled040Visual::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_6_0 = CRBogeyStyles.create("large_create_style_0_6_0", "tripleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_6_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_6_0, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LargeCreateStyled060Renderer(), LargeCreateStyled060Visual::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_8_0 = CRBogeyStyles.create("large_create_style_0_8_0", "quadrupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_8_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_8_0, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LargeCreateStyled080Renderer(), LargeCreateStyled080Visual::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_10_0 = CRBogeyStyles.create("large_create_style_0_10_0", "quintupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_10_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_10_0, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LargeCreateStyled0100Renderer(), LargeCreateStyled0100Visual::new)).build();
    public static final BogeyStyle LARGE_CREATE_STYLED_0_12_0 = CRBogeyStyles.create("large_create_style_0_12_0", "sextupleaxles").displayName((Component)Component.m_237115_((String)"railways.bogeys.styles.large_create_style_0_12_0")).size(BogeySizes.LARGE, CRBlocks.LARGE_CREATE_STYLE_0_12_0, () -> () -> new BogeyStyle.SizeRenderer((BogeyRenderer)new LargeCreateStyled0120Renderer(), LargeCreateStyled0120Visual::new)).build();

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle) {
        CRBogeyStyles.map(from, toType, toStyle, true);
    }

    public static void map(BogeyStyle from, TrackMaterial.TrackType toType, BogeyStyle toStyle, boolean reverseToStandardGauge) {
        STYLES_FOR_GAUGES.put((Pair<BogeyStyle, TrackMaterial.TrackType>)Pair.of((Object)from, (Object)toType), toStyle);
        if (reverseToStandardGauge) {
            CRBogeyStyles.mapReverse(toStyle, from);
        }
    }

    public static void mapReverse(BogeyStyle gaugeStyle, BogeyStyle standardStyle) {
        STYLES_TO_STANDARD_GAUGE.put(gaugeStyle, standardStyle);
    }

    public static boolean styleFitsTrack(BogeyStyle style, TrackMaterial.TrackType trackType) {
        AbstractBogeyBlock<?> bogeyBlock = CRBogeyStyles.getNextBlock(style);
        return bogeyBlock.getValidPathfindingTypes(style).contains(trackType) && trackType != CRTrackMaterials.CRTrackType.MONORAIL ^ bogeyBlock instanceof InvisibleMonoBogeyBlock;
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType) {
        return CRBogeyStyles.getMappedRecursive(from, toType, false);
    }

    private static Optional<BogeyStyle> getMappedRecursive(BogeyStyle from, TrackMaterial.TrackType toType, boolean recursive) {
        if (CRBogeyStyles.getNextBlock(from).getValidPathfindingTypes(from).contains(toType)) {
            return Optional.of(from);
        }
        Pair key = Pair.of((Object)from, (Object)toType);
        if (STYLES_FOR_GAUGES.containsKey(key)) {
            return Optional.of(STYLES_FOR_GAUGES.get(key));
        }
        if (toType == TrackMaterial.TrackType.STANDARD && STYLES_TO_STANDARD_GAUGE.containsKey(from)) {
            return Optional.of(STYLES_TO_STANDARD_GAUGE.get(from));
        }
        if (toType != TrackMaterial.TrackType.STANDARD && !recursive) {
            return CRBogeyStyles.getMappedRecursive(from, TrackMaterial.TrackType.STANDARD, true).flatMap(standardStyle -> CRBogeyStyles.getMappedRecursive(standardStyle, toType, true));
        }
        return Optional.empty();
    }

    public static Optional<BogeyStyle> getMapped(BogeyStyle from, TrackMaterial.TrackType toType, boolean forceFit) {
        Optional<BogeyStyle> mapped = CRBogeyStyles.getMapped(from, toType);
        if (!forceFit || toType == TrackMaterial.TrackType.STANDARD && mapped.isEmpty()) {
            return mapped;
        }
        if (mapped.isEmpty() || !CRBogeyStyles.getNextBlock(mapped.get()).getValidPathfindingTypes(mapped.get()).contains(toType)) {
            return AllBogeyStyles.BOGEY_STYLES.values().stream().filter(style -> CRBogeyStyles.styleFitsTrack(style, toType)).findFirst();
        }
        return mapped;
    }

    public static AbstractBogeyBlock<?> getNextBlock(BogeyStyle style) {
        return style.getNextBlock((BogeySizes.BogeySize)style.validSizes().stream().findFirst().orElseThrow());
    }

    public static void listUnder(BogeyStyle target, BogeyStyle parent) {
        SUB_LISTED_STYLES.add(target);
        List sub = SUB_STYLES.computeIfAbsent(parent, s -> new ArrayList());
        if (!sub.contains(target)) {
            sub.add(target);
        }
    }

    public static boolean hideInSelectionMenu(BogeyStyle style) {
        return SUB_LISTED_STYLES.contains(style);
    }

    public static List<BogeyStyle> getSubStyles(BogeyStyle style) {
        return SUB_STYLES.getOrDefault(style, EMPTY);
    }

    public static BogeyStyle.Builder create(String name, String cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), Railways.asResource(cycleGroup)).displayName((Component)Component.m_237115_((String)("railways.bogeys.styles." + name)));
    }

    public static BogeyStyle.Builder create(String name, ResourceLocation cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), cycleGroup);
    }

    public static BogeyStyle.Builder create(ResourceLocation name, ResourceLocation cycleGroup) {
        return new BogeyStyle.Builder(name, cycleGroup);
    }

    public static CategoryEntry registerCategory(String name) {
        return CRBogeyStyles.registerCategory("railways", name);
    }

    public static CategoryEntry registerCategory(ResourceLocation id) {
        return CRBogeyStyles.registerCategory(id.m_135827_(), id.m_135815_());
    }

    public static CategoryEntry registerCategory(String modid, String name) {
        MutableComponent categoryName = Component.m_237115_((String)(modid + ".gui.bogey_menu.category." + name));
        ResourceLocation categoryId = new ResourceLocation(modid, "bogey_menu/category/" + name);
        return BogeyMenuManager.INSTANCE.registerCategory((Component)categoryName, categoryId);
    }

    private static void addToCategory(CategoryEntry category, BogeyStyle style) {
        CRBogeyStyles.addToCategory(category, style, 23.0f);
    }

    private static void addToCategory(CategoryEntry category, BogeyStyle style, float scale) {
        String bogeyName = style.id.m_135815_();
        if (style == AllBogeyStyles.STANDARD) {
            bogeyName = "default";
        }
        ResourceLocation icon = Railways.asResource("textures/gui/bogey_icons/" + bogeyName + "_icon.png");
        BogeyMenuManager.INSTANCE.addToCategory(category, style, icon, scale);
    }

    private static void setScalesForSizes(BogeyStyle style, BogeySizes.BogeySize size, float scale) {
        BogeyMenuManager.INSTANCE.setScalesForBogeySizes(style, size, scale);
    }

    public static void register() {
        Railways.LOGGER.info("Registered bogey styles from railways");
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.WIDE_GAUGE, WIDE_DEFAULT);
        CRBogeyStyles.map(AllBogeyStyles.STANDARD, CRTrackMaterials.CRTrackType.NARROW_GAUGE, NARROW_DEFAULT);
        CRBogeyStyles.mapReverse(NARROW_DOUBLE_SCOTCH, AllBogeyStyles.STANDARD);
        CRBogeyStyles.mapReverse(WIDE_COMICALLY_LARGE, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(WIDE_DEFAULT, AllBogeyStyles.STANDARD);
        CRBogeyStyles.listUnder(NARROW_DEFAULT, AllBogeyStyles.STANDARD);
        CRBogeyStyles.setScalesForSizes(WIDE_DEFAULT, BogeySizes.SMALL, 20.0f);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, INVISIBLE);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, WIDE_COMICALLY_LARGE, 17.0f);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, AllBogeyStyles.STANDARD);
        CRBogeyStyles.addToCategory(STANDARD_CATEGORY, NARROW_DOUBLE_SCOTCH);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, SINGLEAXLE);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, COILSPRING);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, LEAFSPRING);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, MEDIUM_SINGLE_WHEEL);
        CRBogeyStyles.addToCategory(SINGLEAXLE_CATEGORY, MEDIUM_2_0_2_TRAILING);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MODERN);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, BLOMBERG);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, Y25);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, FREIGHT);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, PASSENGER);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, ARCHBAR);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MEDIUM_STANDARD);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, MEDIUM_4_0_4_TRAILING);
        CRBogeyStyles.addToCategory(DOUBLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_4_0);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, HEAVYWEIGHT, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, RADIAL, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, MEDIUM_6_0_6_TRAILING, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, MEDIUM_6_0_6_TENDER, 20.0f);
        CRBogeyStyles.addToCategory(TRIPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_6_0, 20.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, MEDIUM_QUADRUPLE_WHEEL, 19.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, MEDIUM_8_0_8_TENDER, 19.0f);
        CRBogeyStyles.addToCategory(QUADRUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_8_0, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, MEDIUM_QUINTUPLE_WHEEL, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, MEDIUM_10_0_10_TENDER, 17.0f);
        CRBogeyStyles.addToCategory(QUINTUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_10_0, 15.0f);
        CRBogeyStyles.addToCategory(SEXTUPLEAXLE_CATEGORY, LARGE_CREATE_STYLED_0_12_0, 13.0f);
        if (Utils.isDevEnv()) {
            CategoryEntry ALL_TEST_CATEGORY = CRBogeyStyles.registerCategory("railways", "all_test");
            for (BogeyStyle style : AllBogeyStyles.BOGEY_STYLES.values()) {
                if (CRBogeyStyles.hideInSelectionMenu(style)) continue;
                CRBogeyStyles.addToCategory(ALL_TEST_CATEGORY, style);
            }
        }
    }
}

