/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.RateLimitedThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PriorityTaskPicker {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final ArrayList<Executor> executors = new ArrayList();
    private final ReentrantLock taskPickerLock = new ReentrantLock();
    private final AtomicInteger occupiedThreadsRef = new AtomicInteger(0);
    private final AtomicBoolean isShutDownRef = new AtomicBoolean(false);

    public Executor createExecutor(String name) {
        Executor executor = new Executor(this, name);
        this.executors.add(executor);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryStartNextTask() {
        if (!this.taskPickerLock.tryLock()) {
            return;
        }
        try {
            int maxQueuedBeforeOverflow = Math.max(1, Config.Common.MultiThreading.numberOfThreads.get() / 2);
            Iterator<Executor> iterator = this.getExecutorIteratorSortedByShortestTotalRunTime();
            while (iterator.hasNext()) {
                TrackedRunnable task;
                Executor executor = iterator.next();
                for (int queuedTaskCount = 0; this.occupiedThreadsRef.get() < Config.Common.MultiThreading.numberOfThreads.get() && queuedTaskCount <= maxQueuedBeforeOverflow && (task = (TrackedRunnable)executor.taskQueue.poll()) != null; ++queuedTaskCount) {
                    try {
                        executor.runTask(task);
                        this.occupiedThreadsRef.getAndIncrement();
                        continue;
                    }
                    catch (RejectedExecutionException e) {
                        if (!this.isShutDownRef.get()) throw e;
                        executor.taskQueue.clear();
                        continue;
                    }
                }
                continue;
                return;
            }
        }
        finally {
            this.taskPickerLock.unlock();
        }
    }

    private Iterator<Executor> getExecutorIteratorSortedByShortestTotalRunTime() {
        Stream<Object> stream = this.executors.stream();
        stream = stream.sorted(Comparator.comparingLong(executor -> ((Executor)executor).totalRuntimeNanos.get()));
        return stream.iterator();
    }

    public void shutdownNow() {
        LOGGER.info("Shutting down PriorityTaskPicker thread pool...");
        this.isShutDownRef.set(true);
        try {
            for (int i = 0; i < this.executors.size(); ++i) {
                Executor executor = this.executors.get(i);
                if (executor == null) continue;
                executor.shutdown();
                if (executor.awaitTermination(5L, TimeUnit.SECONDS)) continue;
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Executor
    extends AbstractExecutorService
    implements IConfigListener {
        private final PriorityTaskPicker parentTaskPicker;
        private final String name;
        private final Queue<TrackedRunnable> taskQueue = new ConcurrentLinkedQueue<TrackedRunnable>();
        private final AtomicInteger runningTasksRef = new AtomicInteger(0);
        private final AtomicInteger completedTasksRef = new AtomicInteger(0);
        private final AtomicLong totalRuntimeNanos = new AtomicLong(0L);
        private final RollingAverage runTimeInMsRollingAverage = new RollingAverage(200);
        private RateLimitedThreadPoolExecutor threadPoolExecutor;

        public Executor(PriorityTaskPicker parentTaskPicker, String name) {
            this.parentTaskPicker = parentTaskPicker;
            this.name = name;
            this.threadPoolExecutor = this.createThreadPool();
            Config.Common.MultiThreading.numberOfThreads.addListener(this);
        }

        private RateLimitedThreadPoolExecutor createThreadPool() {
            return new RateLimitedThreadPoolExecutor(Config.Common.MultiThreading.numberOfThreads.get(), new DhThreadFactory(this.name, 1, false), new ArrayBlockingQueue<Runnable>(Runtime.getRuntime().availableProcessors()));
        }

        @Override
        public void onConfigValueSet() {
            RateLimitedThreadPoolExecutor oldExecutor = this.threadPoolExecutor;
            this.threadPoolExecutor = this.createThreadPool();
            if (oldExecutor != null) {
                oldExecutor.shutdown();
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.taskQueue.add(new TrackedRunnable(this.parentTaskPicker, this, command));
            this.parentTaskPicker.tryStartNextTask();
        }

        public void remove(@NotNull Runnable command) {
            this.taskQueue.removeIf(trackedRunnable -> trackedRunnable.command == command);
        }

        public void runTask(@NotNull Runnable command) {
            this.threadPoolExecutor.execute(command);
            this.runningTasksRef.getAndIncrement();
        }

        public int getQueueSize() {
            return this.taskQueue.size();
        }

        public int getPoolSize() {
            return Config.Common.MultiThreading.numberOfThreads.get();
        }

        public int getRunningTaskCount() {
            return this.runningTasksRef.get();
        }

        public int getCompletedTaskCount() {
            return this.completedTasksRef.get();
        }

        public double getAverageRunTimeInMs() {
            return this.runTimeInMsRollingAverage.getAverage();
        }

        @Override
        public void shutdown() {
            this.threadPoolExecutor.shutdown();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return this.threadPoolExecutor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.threadPoolExecutor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.threadPoolExecutor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return this.threadPoolExecutor.awaitTermination(timeout, unit);
        }
    }

    private static class TrackedRunnable
    implements Runnable {
        private final PriorityTaskPicker parentTaskPicker;
        private final Executor executor;
        public final Runnable command;

        public TrackedRunnable(PriorityTaskPicker parentTaskPicker, Executor executor, Runnable command) {
            this.parentTaskPicker = parentTaskPicker;
            this.executor = executor;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.nanoTime();
            try {
                this.command.run();
            }
            finally {
                long timeElapsed = System.nanoTime() - startTime;
                this.executor.runTimeInMsRollingAverage.addValue(TimeUnit.NANOSECONDS.toMillis(timeElapsed));
                this.parentTaskPicker.occupiedThreadsRef.getAndDecrement();
                this.executor.runningTasksRef.getAndDecrement();
                this.executor.completedTasksRef.getAndIncrement();
                this.executor.totalRuntimeNanos.addAndGet(timeElapsed);
                this.parentTaskPicker.tryStartNextTask();
            }
        }
    }
}

