/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;

public abstract class AbstractToolItemModelProvider
extends GenericDataProvider {
    protected final Map<String, JsonObject> models = new HashMap<String, JsonObject>();
    protected final ExistingFileHelper existingFileHelper;
    protected final String modId;

    public AbstractToolItemModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper, String modId) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "models/item");
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
    }

    protected abstract void addModels() throws IOException;

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        try {
            this.addModels();
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return AbstractToolItemModelProvider.allOf(this.models.entrySet().stream().map(entry -> this.saveJson(cache, new ResourceLocation(this.modId, (String)entry.getKey()), entry.getValue(), null)));
    }

    protected void tool(IdAwareObject tool, JsonObject properties, String ... brokenParts) throws IOException {
        ResourceLocation id = tool.getId();
        String name = id.m_135815_();
        this.withDisplay("tool/" + name + "/blocking", id, properties);
        this.transformTool("tool/" + name + "/broken", this.readJson(id), "", false, "broken", brokenParts);
    }

    private static JsonElement serializeVec2(Vec2 vec2) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vec2.f_82470_));
        array.add((Number)Float.valueOf(vec2.f_82471_));
        return array;
    }

    protected void bow(IdAwareObject bow, JsonObject properties, boolean crossbow, String ... pullingParts) throws IOException {
        this.bow(bow, properties, crossbow ? AmmoType.CROSSBOW : AmmoType.BOW, pullingParts);
    }

    protected void bow(IdAwareObject bow, JsonObject properties, AmmoHandler ammo, String ... pullingParts) throws IOException {
        this.pulling(bow, properties, ammo, "bowstring", 3, pullingParts);
    }

    protected void pulling(IdAwareObject bow, JsonObject properties, AmmoHandler ammo, String brokenPart, int pullingCount, String ... pullingParts) throws IOException {
        ResourceLocation id = bow.getId();
        String name = id.m_135815_();
        JsonObject base = this.readJson(id);
        base.remove("overrides");
        this.transformTool("tool/" + name + "/broken", base, "", false, "broken", brokenPart);
        this.withDisplay("tool/" + name + "/blocking", id, properties);
        ammo.apply(this, name, base, properties, pullingCount, pullingParts);
    }

    protected void charged(IdAwareObject bow, JsonObject properties, String ... brokenParts) throws IOException {
        ResourceLocation id = bow.getId();
        String name = id.m_135815_();
        JsonObject base = this.readJson(id);
        base.remove("overrides");
        this.withDisplay("tool/" + name + "/blocking", id, properties);
        this.transformTool("tool/" + name + "/broken", base, "", false, "broken", brokenParts);
        this.addPart(base, "overlay", name, "overlay");
        String charged = "tool/" + name + "/charged";
        this.transformTool(charged, base, "", false, "charged", "overlay");
        this.withDisplay("tool/" + name + "/blocking_charged", this.resource(charged), properties);
    }

    protected void staff(IdAwareObject staff, JsonObject properties) throws IOException {
        ResourceLocation id = staff.getId();
        String path = id.m_135815_();
        String name = path.substring(0, path.length() - "_staff".length());
        JsonObject base = this.readJson(id);
        this.withDisplay("tool/staff/" + name + "/blocking", id, properties);
        this.transformTool("tool/staff/" + name + "/broken", base, "", true, "broken", "tool");
        for (int i = 1; i <= 5; ++i) {
            String charging = "tool/staff/" + name + "/charging_" + i;
            this.transformTool(charging, base, "tconstruct:item/base/staff_charging", false, Integer.toString(i), "tool");
            this.withDisplay("tool/staff/" + name + "/blocking_" + i, this.resource(charging), properties);
        }
    }

    protected void shield(String setName, IdAwareObject shield, JsonObject properties, String ... parts) throws IOException {
        ResourceLocation id = shield.getId();
        this.withDisplay("armor/" + setName + "/shield_blocking", id, Objects.requireNonNull(properties));
        this.transformTool("armor/" + setName + "/shield_broken", this.readJson(id), "", false, "broken", parts);
    }

    protected void armor(String name, EnumObject<ArmorItem.Type, ? extends Item> armor, ArmorItem.Type[] types, String ... textures) throws IOException {
        for (ArmorItem.Type slot : types) {
            this.transformTool("armor/" + name + "/" + slot.m_266355_() + "_broken", this.readJson(Loadables.ITEM.getKey((Object)((Item)armor.get((Enum)slot)))), "", false, "broken", textures);
        }
    }

    protected void armor(String name, EnumObject<ArmorItem.Type, ? extends Item> armor, String ... textures) throws IOException {
        this.armor(name, armor, ArmorItem.Type.values(), textures);
    }

    protected JsonObject readJson(ResourceLocation path) throws IOException {
        try (BufferedReader reader = this.existingFileHelper.getResource(path, PackType.CLIENT_RESOURCES, ".json", "models/item").m_215508_();){
            JsonObject jsonObject = GsonHelper.m_13859_((Reader)reader);
            return jsonObject;
        }
    }

    protected ResourceLocation resource(String name) {
        return new ResourceLocation(this.modId, name);
    }

    protected void withDisplay(String destination, ResourceLocation parent, JsonObject properties) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", parent.m_246208_("item/").toString());
        model.add("display", properties.get("display"));
        this.models.put(destination, model);
    }

    protected static JsonArray copyAndSuffixRoot(JsonArray array, String suffix, boolean allRoots) {
        JsonArray newArray = new JsonArray();
        boolean first = true;
        for (JsonElement element : array) {
            if (allRoots || first) {
                newArray.add(element.getAsString() + suffix);
            }
            newArray.add(element);
            first = false;
        }
        return newArray;
    }

    protected JsonObject addPart(JsonObject tool, String part, String toolName, String texture) {
        JsonObject textures = tool.getAsJsonObject("textures");
        boolean large = GsonHelper.m_13855_((JsonObject)tool, (String)"large", (boolean)false);
        textures.addProperty(part, this.resource("item/tool/" + toolName + "/" + texture).toString());
        if (large) {
            textures.addProperty("large_" + part, this.resource("item/tool/" + toolName + "/large/" + texture).toString());
        }
        JsonObject partObject = new JsonObject();
        partObject.addProperty("name", part);
        tool.getAsJsonArray("parts").add((JsonElement)partObject);
        return tool;
    }

    protected static JsonObject suffixTextures(JsonObject tool, String suffix, String ... updateTextures) {
        boolean large = GsonHelper.m_13855_((JsonObject)tool, (String)"large", (boolean)false);
        JsonObject textures = tool.getAsJsonObject("textures");
        for (String part : updateTextures) {
            textures.addProperty(part, GsonHelper.m_13906_((JsonObject)textures, (String)part) + "_" + suffix);
            if (!large) continue;
            textures.addProperty("large_" + part, GsonHelper.m_13906_((JsonObject)textures, (String)("large_" + part)) + "_" + suffix);
        }
        return tool;
    }

    protected JsonObject transformTool(String destination, JsonObject tool, String parent, boolean allRoots, String suffix, String ... updateTextures) {
        JsonObject transformed = tool.deepCopy();
        if (!parent.isEmpty()) {
            transformed.addProperty("parent", parent);
        }
        AbstractToolItemModelProvider.suffixTextures(transformed, suffix, updateTextures);
        if (GsonHelper.m_13855_((JsonObject)transformed, (String)"large", (boolean)false)) {
            JsonObject roots = transformed.getAsJsonObject("modifier_roots");
            roots.add("small", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(roots.getAsJsonArray("small"), suffix + "/", allRoots));
            roots.add("large", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(roots.getAsJsonArray("large"), suffix + "/", allRoots));
        } else {
            transformed.add("modifier_roots", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(transformed.getAsJsonArray("modifier_roots"), suffix + "/", allRoots));
        }
        transformed.remove("overrides");
        this.models.put(destination, transformed);
        return transformed;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AmmoType implements AmmoHandler
    {
        CROSSBOW{

            @Override
            public void apply(AbstractToolItemModelProvider self, String name, JsonObject base, JsonObject properties, int pullingCount, String[] pullingParts) {
                String arrowName = "tool/" + name + "/arrow";
                String fireworkName = "tool/" + name + "/firework";
                JsonObject ammoBase = AbstractToolItemModelProvider.suffixTextures(base.deepCopy(), "3", pullingParts);
                self.models.put(arrowName, self.addPart(ammoBase.deepCopy(), "ammo", name, "arrow"));
                self.models.put(fireworkName, self.addPart(ammoBase.deepCopy(), "ammo", name, "firework"));
                self.withDisplay("tool/" + name + "/arrow_blocking", self.resource(arrowName), properties);
                self.withDisplay("tool/" + name + "/firework_blocking", self.resource(fireworkName), properties);
                super.apply(self, name, base, properties, pullingCount, pullingParts);
            }
        }
        ,
        BOW{

            @Override
            public void apply(AbstractToolItemModelProvider self, String name, JsonObject base, JsonObject properties, int pullingCount, String[] pullingParts) {
                String[] pullingWithArrow = (String[])Streams.concat((Stream[])new Stream[]{Stream.of("arrow"), Arrays.stream(pullingParts)}).toArray(String[]::new);
                JsonObject withArrow = self.addPart(base.deepCopy(), "arrow", name, "arrow");
                for (int i = 1; i <= pullingCount; ++i) {
                    String pulling = "tool/" + name + "/pulling_arrow_" + i;
                    self.transformTool(pulling, withArrow, "", false, Integer.toString(i), pullingWithArrow);
                    self.withDisplay("tool/" + name + "/blocking_arrow_" + i, self.resource(pulling), properties);
                }
                super.apply(self, name, base, properties, pullingCount, pullingParts);
            }
        }
        ,
        NONE;

    }

    @ApiStatus.NonExtendable
    protected static interface AmmoHandler {
        default public void apply(AbstractToolItemModelProvider self, String name, JsonObject base, JsonObject properties, int pullingCount, String[] pullingParts) {
            for (int i = 1; i <= pullingCount; ++i) {
                String pulling = "tool/" + name + "/pulling_" + i;
                self.transformTool(pulling, base, "", false, Integer.toString(i), pullingParts);
                self.withDisplay("tool/" + name + "/blocking_" + i, self.resource(pulling), properties);
            }
        }
    }

    public record LongbowAmmo(Vec2[] smallOffsets, Vec2[] largeOffsets, boolean flipAmmo, boolean leftAmmo) implements AmmoHandler
    {
        @Override
        public void apply(AbstractToolItemModelProvider self, String name, JsonObject base, JsonObject properties, int pullingCount, String[] pullingParts) {
            for (int i = 1; i <= pullingCount; ++i) {
                String pulling = "tool/" + name + "/pulling_" + i;
                JsonObject arrow = self.transformTool(pulling, base, "", false, Integer.toString(i), pullingParts);
                JsonObject ammo = new JsonObject();
                ammo.addProperty("key", ModifiableLauncherItem.KEY_DRAWBACK_AMMO.toString());
                ammo.addProperty("flip", Boolean.valueOf(this.flipAmmo));
                ammo.addProperty("left", Boolean.valueOf(this.leftAmmo));
                ammo.add("small_offset", AbstractToolItemModelProvider.serializeVec2(this.smallOffsets[i - 1]));
                ammo.add("large_offset", AbstractToolItemModelProvider.serializeVec2(this.largeOffsets[i - 1]));
                arrow.add("ammo", (JsonElement)ammo);
                self.withDisplay("tool/" + name + "/blocking_" + i, self.resource(pulling), properties);
            }
        }
    }

    public record CrossbowAmmo(Vec2 ammoOffset, boolean flipAmmo, boolean leftAmmo) implements AmmoHandler
    {
        @Override
        public void apply(AbstractToolItemModelProvider self, String name, JsonObject base, JsonObject properties, int pullingCount, String[] pullingParts) {
            String fireworkName = "tool/" + name + "/firework";
            JsonObject ammoBase = AbstractToolItemModelProvider.suffixTextures(base.deepCopy(), "3", pullingParts);
            self.models.put(fireworkName, self.addPart(ammoBase.deepCopy(), "ammo", name, "firework"));
            self.withDisplay("tool/" + name + "/firework_blocking", self.resource(fireworkName), properties);
            for (int i = 1; i < pullingCount; ++i) {
                String pulling = "tool/" + name + "/pulling_" + i;
                self.transformTool(pulling, base, "", false, Integer.toString(i), pullingParts);
                self.withDisplay("tool/" + name + "/blocking_" + i, self.resource(pulling), properties);
            }
            String pulling = "tool/" + name + "/pulling_" + pullingCount;
            JsonObject arrow = self.transformTool(pulling, base, "", false, Integer.toString(pullingCount), pullingParts);
            self.withDisplay("tool/" + name + "/blocking_" + pullingCount, self.resource(pulling), properties);
            JsonObject ammo = new JsonObject();
            ammo.addProperty("key", ModifiableCrossbowItem.KEY_CROSSBOW_AMMO.toString());
            ammo.addProperty("flip", Boolean.valueOf(this.flipAmmo));
            ammo.addProperty("left", Boolean.valueOf(this.leftAmmo));
            ammo.add("offset", AbstractToolItemModelProvider.serializeVec2(this.ammoOffset));
            arrow.add("ammo", (JsonElement)ammo);
        }
    }
}

