/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;

public class MultitankFuelModule
extends FuelModule
implements IFluidHandler {
    private static final BlockPos NULL_POS = new BlockPos(0, Short.MIN_VALUE, 0);
    private final Supplier<List<BlockPos>> tankSupplier;
    private BlockPos lastPos = NULL_POS;
    private Map<BlockPos, LazyOptional<IFluidHandler>> tankHandlers;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> tankHandlerListener = new WeakConsumerWrapper((Object)this, (self, cap) -> {
        if (self.tankHandlers != null) {
            self.tankHandlers.values().remove(cap);
        }
    });
    private static final String TAG_LAST_FUEL = "last_fuel";
    private static final int LAST_X = 4;
    private static final int LAST_Y = 5;
    private static final int LAST_Z = 6;

    public MultitankFuelModule(MantleBlockEntity parent, Supplier<List<BlockPos>> tankSupplier) {
        super(parent);
        this.tankSupplier = tankSupplier;
    }

    private void clearLastListener() {
        super.resetHandler(null);
    }

    @Override
    protected void resetHandler(@Nullable LazyOptional<?> source) {
        if (source == null || source == this.fluidHandler) {
            this.lastPos = NULL_POS;
        }
        super.resetHandler(source);
    }

    public void clearFluidListeners() {
        if (this.tankHandlers != null) {
            if (Util.isForge()) {
                for (LazyOptional<IFluidHandler> handler : this.tankHandlers.values()) {
                    handler.removeListener(this.tankHandlerListener);
                }
            }
            this.tankHandlers = null;
        }
    }

    private Map<BlockPos, LazyOptional<IFluidHandler>> getTankHandlers() {
        if (this.tankHandlers == null) {
            this.tankHandlers = new LinkedHashMap<BlockPos, LazyOptional<IFluidHandler>>();
            Level world = this.getLevel();
            for (BlockPos pos : this.tankSupplier.get()) {
                LazyOptional handler;
                BlockEntity te = world.m_7702_(pos);
                if (te == null || !(handler = te.getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) continue;
                handler.addListener(this.tankHandlerListener);
                this.tankHandlers.put(pos, (LazyOptional<IFluidHandler>)handler);
            }
        }
        return this.tankHandlers;
    }

    private int tryFuelPosition(BlockPos pos, boolean consume) {
        int temperature;
        LazyOptional<IFluidHandler> tankCap = this.getTankHandlers().get(pos);
        if (tankCap != null && tankCap.isPresent() && (temperature = this.tryLiquidFuel((IFluidHandler)tankCap.orElse((Object)EmptyFluidHandler.INSTANCE), consume)) > 0) {
            this.clearLastListener();
            this.fluidHandler = tankCap;
            tankCap.addListener(this.fluidListener);
            this.lastPos = pos;
            return temperature;
        }
        return 0;
    }

    @Override
    public int findFuel(boolean consume) {
        int posTemp;
        if (this.fluidHandler != null) {
            int temperature;
            if (this.fluidHandler.isPresent() && (temperature = this.tryLiquidFuel((IFluidHandler)this.fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE), consume)) > 0) {
                return temperature;
            }
        } else if (this.lastPos != NULL_POS && (posTemp = this.tryFuelPosition(this.lastPos, consume)) > 0) {
            return posTemp;
        }
        for (BlockPos pos : this.tankSupplier.get()) {
            int posTemp2;
            if (pos.equals((Object)this.lastPos) || (posTemp2 = this.tryFuelPosition(pos, consume)) <= 0) continue;
            return posTemp2;
        }
        if (consume) {
            this.temperature = 0;
            this.rate = 0;
        }
        return 0;
    }

    @Override
    public void readFromTag(CompoundTag nbt) {
        super.readFromTag(nbt);
        if (nbt.m_128425_(TAG_LAST_FUEL, 10)) {
            this.lastPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(TAG_LAST_FUEL)).m_121955_((Vec3i)this.parent.m_58899_());
        }
    }

    @Override
    public CompoundTag writeToTag(CompoundTag nbt) {
        nbt = super.writeToTag(nbt);
        if (this.lastPos != NULL_POS) {
            nbt.m_128365_(TAG_LAST_FUEL, (Tag)NbtUtils.m_129224_((BlockPos)this.lastPos.m_121996_((Vec3i)this.parent.m_58899_())));
        }
        return nbt;
    }

    @Override
    public int m_6499_() {
        return 7;
    }

    @Override
    public int m_6413_(int index) {
        return switch (index) {
            case 4 -> this.lastPos.m_123341_();
            case 5 -> this.lastPos.m_123342_();
            case 6 -> this.lastPos.m_123343_();
            default -> super.m_6413_(index);
        };
    }

    @Override
    public void m_8050_(int index, int value) {
        if (4 <= index && index <= 6) {
            switch (index) {
                case 4: {
                    this.lastPos = new BlockPos(value, this.lastPos.m_123342_(), this.lastPos.m_123343_());
                    break;
                }
                case 5: {
                    this.lastPos = new BlockPos(this.lastPos.m_123341_(), value, this.lastPos.m_123343_());
                    break;
                }
                case 6: {
                    this.lastPos = new BlockPos(this.lastPos.m_123341_(), this.lastPos.m_123342_(), value);
                }
            }
            this.clearLastListener();
        } else {
            super.m_8050_(index, value);
        }
    }

    @Override
    public FuelModule.FuelInfo getFuelInfo() {
        FuelModule.FuelInfo info;
        BlockPos mainTank = this.lastPos;
        if (mainTank.m_123342_() == NULL_POS.m_123342_()) {
            List<BlockPos> positions = this.tankSupplier.get();
            if (positions.isEmpty()) {
                return FuelModule.FuelInfo.EMPTY;
            }
            mainTank = positions.get(0);
            assert (mainTank != null);
        }
        if (this.fluidHandler == null) {
            LazyOptional<IFluidHandler> fluidCap = this.getTankHandlers().getOrDefault(mainTank, (LazyOptional<IFluidHandler>)LazyOptional.empty());
            if (fluidCap.isPresent()) {
                this.fluidHandler = fluidCap;
                this.fluidHandler.addListener(this.fluidListener);
            } else {
                this.fluidHandler = LazyOptional.empty();
            }
        }
        if (!(info = super.getFuelInfo()).isEmpty()) {
            FluidStack currentFuel = info.getFluid();
            for (Map.Entry<BlockPos, LazyOptional<IFluidHandler>> entry : this.getTankHandlers().entrySet()) {
                if (mainTank.equals((Object)entry.getKey())) continue;
                entry.getValue().ifPresent(handler -> {
                    FluidStack fluid = handler.getFluidInTank(0);
                    if (fluid.isEmpty()) {
                        info.add(0, handler.getTankCapacity(0));
                    } else if (currentFuel.isFluidEqual(fluid)) {
                        info.add(fluid.getAmount(), handler.getTankCapacity(0));
                    }
                });
            }
        }
        return info;
    }

    public FluidStack getLastFluid() {
        BlockPos pos;
        if (this.fluidHandler != null && this.fluidHandler.isPresent()) {
            return ((IFluidHandler)this.fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
        }
        if (this.lastPos.m_123342_() != NULL_POS.m_123342_()) {
            pos = this.lastPos;
        } else {
            List<BlockPos> positions = this.tankSupplier.get();
            if (!positions.isEmpty()) {
                pos = positions.get(0);
            } else {
                return FluidStack.EMPTY;
            }
        }
        return ((IFluidHandler)this.getTankHandlers().getOrDefault(pos, (LazyOptional<IFluidHandler>)LazyOptional.empty()).orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
    }

    public int getTanks() {
        return this.tankSupplier.get().size();
    }

    private IFluidHandler getTank(int tank) {
        List<BlockPos> positions;
        if (tank >= 0 && tank < (positions = this.tankSupplier.get()).size()) {
            return (IFluidHandler)this.getTankHandlers().getOrDefault(positions.get(tank), (LazyOptional<IFluidHandler>)LazyOptional.empty()).orElse((Object)EmptyFluidHandler.INSTANCE);
        }
        return EmptyFluidHandler.INSTANCE;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getTank(tank).getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getTank(tank).isFluidValid(0, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFilled = 0;
        resource = resource.copy();
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            int filled = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).fill(resource, action);
            if (filled <= 0) continue;
            totalFilled += filled;
            if (filled >= resource.getAmount()) break;
            if (totalFilled == filled) {
                resource = new FluidStack(resource, resource.getAmount() - filled);
                continue;
            }
            resource.shrink(filled);
        }
        return totalFilled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            FluidStack drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(resource, action);
            if (drained.isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                drainedSoFar = drained;
                if (drained.getAmount() >= resource.getAmount()) break;
                resource = new FluidStack(resource, resource.getAmount() - drained.getAmount());
                continue;
            }
            drainedSoFar.grow(drained.getAmount());
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            FluidStack drained;
            if (toDrain.isEmpty()) {
                drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(maxDrain, action);
                if (drained.isEmpty()) continue;
                drainedSoFar = drained;
                if (drained.getAmount() >= maxDrain) break;
                toDrain = new FluidStack(drained, maxDrain - drained.getAmount());
                continue;
            }
            drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(toDrain, action);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }
}

