/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.internal.math;

public class Gamma {
    public static double gamma(double x) {
        if (x <= 0.0) {
            String msg = String.format("Invalid input argument {0}. Argument must be positive.", x);
            throw new IllegalArgumentException(msg);
        }
        double gamma = 0.5772156649015329;
        if (x < 0.001) {
            return 1.0 / (x * (1.0 + 0.5772156649015329 * x));
        }
        if (x < 12.0) {
            int i;
            boolean arg_was_less_than_one;
            double y = x;
            int n = 0;
            boolean bl = arg_was_less_than_one = y < 1.0;
            if (arg_was_less_than_one) {
                y += 1.0;
            } else {
                n = (int)Math.floor(y) - 1;
                y -= (double)n;
            }
            double[] p = new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054};
            double[] q = new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349};
            double num = 0.0;
            double den = 1.0;
            double z = y - 1.0;
            for (i = 0; i < 8; ++i) {
                num = (num + p[i]) * z;
                den = den * z + q[i];
            }
            double result = num / den + 1.0;
            if (arg_was_less_than_one) {
                result /= y - 1.0;
            } else {
                for (i = 0; i < n; ++i) {
                    double d = y;
                    y = d + 1.0;
                    result *= d;
                }
            }
            return result;
        }
        if (x > 171.624) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.exp(Gamma.logGamma(x));
    }

    public static double logGamma(double x) {
        if (x <= 0.0) {
            String msg = String.format("Invalid input argument {0}. Argument must be positive.", x);
            throw new IllegalArgumentException(msg);
        }
        if (x < 12.0) {
            return Math.log(Math.abs(Gamma.gamma(x)));
        }
        double[] c = new double[]{0.08333333333333333, -0.002777777777777778, 7.936507936507937E-4, -5.952380952380953E-4, 8.417508417508417E-4, -0.0019175269175269176, 0.00641025641025641, -0.029550653594771242};
        double z = 1.0 / (x * x);
        double sum = c[7];
        for (int i = 6; i >= 0; --i) {
            sum *= z;
            sum += c[i];
        }
        double series = sum / x;
        double halfLogTwoPi = 0.9189385332046728;
        double logGamma = (x - 0.5) * Math.log(x) - x + halfLogTwoPi + series;
        return logGamma;
    }
}

