/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.gui.WildfireBreastPresetList;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.WildfireSlider;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.Breasts;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.config.BreastPresetConfiguration;
import com.wildfire.main.config.ClientConfiguration;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLLoader;

public class WildfireBreastCustomizationScreen
extends BaseWildfireScreen {
    private WildfireSlider breastSlider;
    private WildfireSlider xOffsetBoobSlider;
    private WildfireSlider yOffsetBoobSlider;
    private WildfireSlider zOffsetBoobSlider;
    private WildfireSlider cleavageSlider;
    private WildfireButton btnDualPhysics;
    private WildfireButton btnPresets;
    private WildfireButton btnCustomization;
    private WildfireButton btnAddPreset;
    private WildfireButton btnDeletePreset;
    private WildfireBreastPresetList PRESET_LIST;
    private Tab currentTab = Tab.CUSTOMIZATION;

    public WildfireBreastCustomizationScreen(Screen parent, UUID uuid) {
        super((Component)Component.m_237115_((String)"wildfire_gender.appearance_settings.title"), parent, uuid);
    }

    public void m_7856_() {
        int j = this.f_96544_ / 2 - 11;
        GenderPlayer plr = this.getPlayer();
        Breasts breasts = plr.getBreasts();
        FloatConsumer onSave = value -> GenderPlayer.saveGenderInfo(plr);
        this.m_142416_((GuiEventListener)new WildfireButton(this.f_96543_ / 2 + 178, j - 72, 9, 9, (Component)Component.m_237113_((String)"X"), button -> Minecraft.m_91087_().m_91152_(this.parent)));
        this.btnCustomization = new WildfireButton(this.f_96543_ / 2 + 30, j - 60, 78, 10, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.tab_customization"), button -> {
            this.currentTab = Tab.CUSTOMIZATION;
            this.updatePresetTab();
        });
        this.m_142416_((GuiEventListener)this.btnCustomization);
        this.btnPresets = new WildfireButton(this.f_96543_ / 2 + 31 + 79, j - 60, 78, 10, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.tab_presets"), button -> {
            if (FMLLoader.isProduction()) {
                return;
            }
            this.currentTab = Tab.PRESETS;
            this.PRESET_LIST.refreshList();
            this.updatePresetTab();
        });
        this.m_142416_((GuiEventListener)this.btnPresets);
        if (FMLLoader.isProduction()) {
            this.btnPresets.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"wildfire_gender.coming_soon")));
        }
        this.btnAddPreset = new WildfireButton(this.f_96543_ / 2 + 31 + 79, j + 80, 78, 12, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.presets.add_new"), button -> this.createNewPreset("Test Preset"));
        this.m_142416_((GuiEventListener)this.btnAddPreset);
        this.btnDeletePreset = new WildfireButton(this.f_96543_ / 2 + 30, j + 80, 78, 12, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.presets.delete"), button -> {});
        ((WildfireButton)this.m_142416_((GuiEventListener)new WildfireButton(this.f_96543_ / 2 + 30, j + 80, 78, 12, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.presets.delete"), button -> {}))).f_93623_ = false;
        this.breastSlider = new WildfireSlider(this.f_96543_ / 2 + 30, j - 48, 158, 20, ClientConfiguration.BUST_SIZE, plr.getBustSize(), plr::updateBustSize, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.wardrobe.slider.breast_size", (Object[])new Object[]{Math.round(value * 125.0f)})), onSave);
        this.m_142416_((GuiEventListener)this.breastSlider);
        this.xOffsetBoobSlider = new WildfireSlider(this.f_96543_ / 2 + 30, j - 27, 158, 20, ClientConfiguration.BREASTS_OFFSET_X, breasts.getXOffset(), breasts::updateXOffset, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.wardrobe.slider.separation", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.m_142416_((GuiEventListener)this.xOffsetBoobSlider);
        this.yOffsetBoobSlider = new WildfireSlider(this.f_96543_ / 2 + 30, j - 6, 158, 20, ClientConfiguration.BREASTS_OFFSET_Y, breasts.getYOffset(), breasts::updateYOffset, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.wardrobe.slider.height", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.m_142416_((GuiEventListener)this.yOffsetBoobSlider);
        this.zOffsetBoobSlider = new WildfireSlider(this.f_96543_ / 2 + 30, j + 15, 158, 20, ClientConfiguration.BREASTS_OFFSET_Z, breasts.getZOffset(), breasts::updateZOffset, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.wardrobe.slider.depth", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.m_142416_((GuiEventListener)this.zOffsetBoobSlider);
        this.cleavageSlider = new WildfireSlider(this.f_96543_ / 2 + 30, j + 36, 158, 20, ClientConfiguration.BREASTS_CLEAVAGE, breasts.getCleavage(), breasts::updateCleavage, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.wardrobe.slider.rotation", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 100.0f)})), onSave);
        this.m_142416_((GuiEventListener)this.cleavageSlider);
        this.btnDualPhysics = new WildfireButton(this.f_96543_ / 2 + 30, j + 57, 158, 20, (Component)Component.m_237110_((String)"wildfire_gender.breast_customization.dual_physics", (Object[])new Object[]{Component.m_237115_((String)(breasts.isUniboob() ? "wildfire_gender.label.no" : "wildfire_gender.label.yes"))}), button -> {
            boolean isUniboob;
            boolean bl = isUniboob = !breasts.isUniboob();
            if (breasts.updateUniboob(isUniboob)) {
                button.m_93666_((Component)Component.m_237110_((String)"wildfire_gender.breast_customization.dual_physics", (Object[])new Object[]{Component.m_237115_((String)(isUniboob ? "wildfire_gender.label.no" : "wildfire_gender.label.yes"))}));
                GenderPlayer.saveGenderInfo(plr);
            }
        });
        this.m_142416_((GuiEventListener)this.btnDualPhysics);
        this.PRESET_LIST = new WildfireBreastPresetList(this, 156, j - 48, j + 77);
        this.PRESET_LIST.m_93507_(this.f_96543_ / 2 + 30);
        this.m_7787_((GuiEventListener)this.PRESET_LIST);
        this.currentTab = Tab.CUSTOMIZATION;
        this.updatePresetTab();
        super.m_7856_();
    }

    private void createNewPreset(String presetName) {
        BreastPresetConfiguration cfg = new BreastPresetConfiguration(presetName);
        cfg.set(BreastPresetConfiguration.PRESET_NAME, presetName);
        GenderPlayer player = this.getPlayer();
        cfg.set(BreastPresetConfiguration.BUST_SIZE, Float.valueOf(player.getBustSize()));
        cfg.set(BreastPresetConfiguration.BREASTS_UNIBOOB, player.getBreasts().isUniboob());
        cfg.set(BreastPresetConfiguration.BREASTS_CLEAVAGE, Float.valueOf(player.getBreasts().getCleavage()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_X, Float.valueOf(player.getBreasts().getXOffset()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_Y, Float.valueOf(player.getBreasts().getYOffset()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_Z, Float.valueOf(player.getBreasts().getZOffset()));
        cfg.save();
        this.PRESET_LIST.refreshList();
    }

    private void updatePresetTab() {
        boolean displayBreastSettings;
        this.breastSlider.f_93624_ = displayBreastSettings = this.getPlayer().getGender().canHaveBreasts() && this.currentTab == Tab.CUSTOMIZATION;
        this.xOffsetBoobSlider.f_93624_ = displayBreastSettings;
        this.yOffsetBoobSlider.f_93624_ = displayBreastSettings;
        this.zOffsetBoobSlider.f_93624_ = displayBreastSettings;
        this.cleavageSlider.f_93624_ = displayBreastSettings;
        this.btnDualPhysics.f_93624_ = displayBreastSettings;
        this.PRESET_LIST.visible = this.currentTab == Tab.PRESETS;
        this.btnCustomization.f_93623_ = this.currentTab != Tab.CUSTOMIZATION;
        this.btnPresets.f_93623_ = this.currentTab != Tab.PRESETS;
        this.btnAddPreset.f_93624_ = this.currentTab == Tab.PRESETS;
        this.btnDeletePreset.f_93624_ = this.currentTab == Tab.PRESETS;
    }

    public void m_280273_(@Nonnull GuiGraphics graphics) {
        super.m_280273_(graphics);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        graphics.m_280509_(x + 28, y - 64 - 21, x + 190, y + 68, 0x55000000);
        graphics.m_280509_(x + 29, y - 63 - 21, x + 189, y - 60, 0x55000000);
        graphics.m_280614_(this.f_96547_, this.m_96636_(), x + 32, y - 60 - 21, 0xFFFFFF, false);
        if (this.currentTab == Tab.PRESETS) {
            graphics.m_280509_(this.PRESET_LIST.getLeft(), this.PRESET_LIST.getTop(), this.PRESET_LIST.getRight(), this.PRESET_LIST.getBottom(), 0x55000000);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Player ent;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (ent = this.f_96541_.f_91073_.m_46003_(this.playerUUID)) != null) {
            InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(x - 102), (int)(y + 275), (int)200, (float)-20.0f, (float)-20.0f, (LivingEntity)ent);
        }
        if (this.currentTab == Tab.PRESETS) {
            this.PRESET_LIST.m_88315_(graphics, mouseX, mouseY, delta);
            if (!this.PRESET_LIST.hasPresets()) {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"wildfire_gender.breast_customization.presets.none"), x + 109, y - 4, 0xFFFFFF);
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.breastSlider.save();
        this.xOffsetBoobSlider.save();
        this.yOffsetBoobSlider.save();
        this.zOffsetBoobSlider.save();
        this.cleavageSlider.save();
        return super.m_6348_(mouseX, mouseY, state);
    }

    private static enum Tab {
        CUSTOMIZATION,
        PRESETS;

    }
}

