/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.main.Breasts;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.config.ClientConfiguration;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.main.config.Configuration;
import com.wildfire.physics.BreastPhysics;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class GenderPlayer {
    public boolean needsSync;
    public final UUID uuid;
    private Gender gender;
    private float pBustSize = ((Float)ClientConfiguration.BUST_SIZE.getDefault()).floatValue();
    private boolean hurtSounds = (Boolean)ClientConfiguration.HURT_SOUNDS.getDefault();
    private boolean breastPhysics = (Boolean)ClientConfiguration.BREAST_PHYSICS.getDefault();
    private float bounceMultiplier = ((Float)ClientConfiguration.BOUNCE_MULTIPLIER.getDefault()).floatValue();
    private float floppyMultiplier = ((Float)ClientConfiguration.FLOPPY_MULTIPLIER.getDefault()).floatValue();
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private boolean showBreastsInArmor = (Boolean)ClientConfiguration.SHOW_IN_ARMOR.getDefault();
    private boolean armorPhysOverride = (Boolean)ClientConfiguration.ARMOR_PHYSICS_OVERRIDE.getDefault();
    private final ClientConfiguration cfg;
    private final BreastPhysics lBreastPhysics = new BreastPhysics(this);
    private final BreastPhysics rBreastPhysics = new BreastPhysics(this);
    private final Breasts breasts = new Breasts();

    public GenderPlayer(UUID uuid) {
        this(uuid, (Gender)((Object)ClientConfiguration.GENDER.getDefault()));
    }

    public GenderPlayer(UUID uuid, Gender gender) {
        this.uuid = uuid;
        this.gender = gender;
        this.cfg = new ClientConfiguration("WildfireGender", this.uuid.toString());
        this.cfg.set(ClientConfiguration.USERNAME, this.uuid);
        this.cfg.setDefaults(ClientConfiguration.GENDER, ClientConfiguration.BUST_SIZE, ClientConfiguration.HURT_SOUNDS, ClientConfiguration.BREASTS_OFFSET_X, ClientConfiguration.BREASTS_OFFSET_Y, ClientConfiguration.BREASTS_OFFSET_Z, ClientConfiguration.BREASTS_UNIBOOB, ClientConfiguration.BREASTS_CLEAVAGE, ClientConfiguration.BREAST_PHYSICS, ClientConfiguration.ARMOR_PHYSICS_OVERRIDE, ClientConfiguration.SHOW_IN_ARMOR, ClientConfiguration.BOUNCE_MULTIPLIER, ClientConfiguration.FLOPPY_MULTIPLIER);
        this.cfg.finish();
    }

    public ClientConfiguration getConfig() {
        return this.cfg;
    }

    private <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public <VALUE> boolean updateFrom(ConfigKey<VALUE> key, Configuration copyFrom, Consumer<VALUE> setter) {
        VALUE value = copyFrom.get(key);
        if (value == null) {
            return false;
        }
        return this.updateValue(key, value, setter);
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(ClientConfiguration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(ClientConfiguration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean updateBustSize(Configuration copyFrom) {
        return this.updateFrom(ClientConfiguration.BUST_SIZE, copyFrom, v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(ClientConfiguration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean hasBreastPhysics() {
        return this.breastPhysics;
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(ClientConfiguration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    public boolean getArmorPhysicsOverride() {
        return this.armorPhysOverride;
    }

    public boolean updateArmorPhysicsOverride(boolean value) {
        return this.updateValue(ClientConfiguration.ARMOR_PHYSICS_OVERRIDE, value, v -> {
            this.armorPhysOverride = v;
        });
    }

    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(ClientConfiguration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public float getBounceMultiplier() {
        return (float)Math.round(this.getBounceMultiplierRaw() * 3.0f * 100.0f) / 100.0f;
    }

    public float getBounceMultiplierRaw() {
        return this.bounceMultiplier;
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(ClientConfiguration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(ClientConfiguration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public static GenderPlayer loadCachedPlayer(UUID uuid, boolean markForSync) {
        GenderPlayer plr = WildfireGender.getPlayerById(uuid);
        if (plr != null) {
            plr.syncStatus = SyncStatus.CACHED;
            ClientConfiguration config = plr.getConfig();
            plr.updateGender(config.get(ClientConfiguration.GENDER));
            plr.updateBustSize(config);
            plr.updateHurtSounds(config.get(ClientConfiguration.HURT_SOUNDS));
            plr.updateBreastPhysics(config.get(ClientConfiguration.BREAST_PHYSICS));
            plr.updateShowBreastsInArmor(config.get(ClientConfiguration.SHOW_IN_ARMOR));
            plr.updateArmorPhysicsOverride(config.get(ClientConfiguration.ARMOR_PHYSICS_OVERRIDE));
            plr.updateBounceMultiplier(config.get(ClientConfiguration.BOUNCE_MULTIPLIER).floatValue());
            plr.updateFloppiness(config.get(ClientConfiguration.FLOPPY_MULTIPLIER).floatValue());
            plr.getBreasts().copyFrom(config);
            if (markForSync) {
                plr.needsSync = true;
            }
            return plr;
        }
        return null;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        ClientConfiguration config = plr.getConfig();
        config.set(ClientConfiguration.USERNAME, plr.uuid);
        config.set(ClientConfiguration.GENDER, plr.getGender());
        config.set(ClientConfiguration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        config.set(ClientConfiguration.HURT_SOUNDS, plr.hasHurtSounds());
        config.set(ClientConfiguration.BREAST_PHYSICS, plr.hasBreastPhysics());
        config.set(ClientConfiguration.SHOW_IN_ARMOR, plr.showBreastsInArmor());
        config.set(ClientConfiguration.ARMOR_PHYSICS_OVERRIDE, plr.getArmorPhysicsOverride());
        config.set(ClientConfiguration.BOUNCE_MULTIPLIER, Float.valueOf(plr.getBounceMultiplierRaw()));
        config.set(ClientConfiguration.FLOPPY_MULTIPLIER, Float.valueOf(plr.getFloppiness()));
        config.set(ClientConfiguration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        config.set(ClientConfiguration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        config.set(ClientConfiguration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        config.set(ClientConfiguration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        config.set(ClientConfiguration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        config.save();
        plr.needsSync = true;
    }

    public Breasts getBreasts() {
        return this.breasts;
    }

    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public static enum Gender {
        FEMALE((Component)Component.m_237115_((String)"wildfire_gender.label.female").m_130940_(ChatFormatting.LIGHT_PURPLE), true, WildfireSounds.FEMALE_HURT),
        MALE((Component)Component.m_237115_((String)"wildfire_gender.label.male").m_130940_(ChatFormatting.BLUE), false, null),
        OTHER((Component)Component.m_237115_((String)"wildfire_gender.label.other").m_130940_(ChatFormatting.GREEN), true, null);

        private final Component name;
        @Nullable
        private final SoundEvent hurtSound;
        private final boolean canHaveBreasts;

        private Gender(@Nullable Component name, boolean canHaveBreasts, SoundEvent hurtSound) {
            this.name = name;
            this.canHaveBreasts = canHaveBreasts;
            this.hurtSound = hurtSound;
        }

        public Component getDisplayName() {
            return this.name;
        }

        @Nullable
        public SoundEvent getHurtSound() {
            return this.hurtSound;
        }

        public boolean canHaveBreasts() {
            return this.canHaveBreasts;
        }
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

