/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.wildfire.main.config.ConfigKey;
import javax.annotation.Nullable;

public abstract class NumberConfigKey<TYPE extends Number>
extends ConfigKey<TYPE> {
    @Nullable
    protected final TYPE minInclusive;
    @Nullable
    protected final TYPE maxInclusive;

    protected NumberConfigKey(String key, TYPE defaultValue) {
        this(key, defaultValue, null, null);
    }

    protected NumberConfigKey(String key, TYPE defaultValue, @Nullable TYPE minInclusive, @Nullable TYPE maxInclusive) {
        super(key, defaultValue);
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    protected abstract TYPE fromPrimitive(JsonPrimitive var1);

    @Override
    protected TYPE read(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && ((primitive = element.getAsJsonPrimitive()).isNumber() || primitive.isString())) {
            try {
                return this.fromPrimitive(primitive);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (TYPE)((Number)this.defaultValue);
    }

    @Override
    public void save(JsonObject object, TYPE value) {
        object.addProperty(this.key, value);
    }

    @Override
    public boolean validate(TYPE value) {
        if (super.validate(value)) {
            return !(this.minInclusive != null && ((Comparable)this.minInclusive).compareTo(value) > 0 || this.maxInclusive != null && ((Comparable)this.maxInclusive).compareTo(value) < 0);
        }
        return false;
    }
}

