/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.block;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.ScruffyLeavesProperties;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ForgeSoundType;

public class CobwebLeavesProperties
extends ScruffyLeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(CobwebLeavesProperties::new);
    private float leafChance = 0.66f;
    private int maxHydro = 1;

    public CobwebLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    public String getBlockRegistryNameSuffix() {
        return "_web";
    }

    public void setLeafChance(float leafChance) {
        this.leafChance = leafChance;
    }

    public void setMaxHydro(int maxHydro) {
        this.maxHydro = maxHydro;
    }

    protected DynamicLeavesBlock createDynamicLeaves(BlockBehaviour.Properties properties) {
        return new DynamicLeavesBlock((LeavesProperties)this, properties){

            public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
            }

            public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
                entity.m_7601_(state, new Vec3(0.25, (double)0.05f, 0.25));
            }

            public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
                return new ForgeSoundType(1.0f, 1.0f, () -> SoundEvents.f_12580_, () -> SoundEvents.f_12580_, () -> SoundEvents.f_12580_, () -> SoundEvents.f_11990_, () -> SoundEvents.f_12580_);
            }

            public int getHydrationLevelFromNeighbors(LevelAccessor level, BlockPos pos, LeavesProperties leavesProperties) {
                int hash;
                float rand;
                int hydro = super.getHydrationLevelFromNeighbors(level, pos, leavesProperties);
                if (hydro <= CobwebLeavesProperties.this.maxHydro && (rand = (float)(hash = CoordUtils.coordHashCode((BlockPos)pos, (int)2) % 1000) / 1000.0f) >= CobwebLeavesProperties.this.leafChance) {
                    return 0;
                }
                return hydro;
            }
        };
    }
}

