/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RedwoodLogic
extends GrowthLogicKit {
    public RedwoodLogic(ResourceLocation registryName) {
        super(registryName);
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Level level = context.level();
        BlockPos pos = context.pos();
        Species species = context.species();
        GrowSignal signal = context.signal();
        Direction originDir = signal.dir.m_122424_();
        int signalY = signal.delta.m_123342_();
        if (signal.numSteps + 1 <= configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) {
            return Direction.UP;
        }
        int[] probMap = new int[6];
        probMap[Direction.UP.ordinal()] = signal.dir != Direction.DOWN ? species.getUpProbability() : 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + species.getProbabilityForCurrentDir();
        int radius = context.branch().getRadius(level.m_8055_(pos));
        if (signal.delta.m_123342_() < configuration.getLowestBranchHeight((PositionalSpeciesContext)context) - 3) {
            boolean sideTurn;
            int treeHash = this.getHashedVariation(level, signal.rootPos, 2);
            int posHash = this.getHashedVariation(level, pos, 2);
            int hashMod = signalY < 7 ? 3 : 11;
            boolean bl = sideTurn = !signal.isInTrunk() || signal.isInTrunk() && (signal.numSteps + treeHash) % hashMod == 0 && radius > 1;
            if (!sideTurn) {
                return Direction.UP;
            }
            probMap[2 + posHash % 4] = 1;
        }
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = pos.m_121955_(dir.m_122436_());
            if (signalY < configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) continue;
            BlockState deltaBlockState = level.m_8055_(deltaPos);
            TreePart treePart = TreeHelper.getTreePart((BlockState)deltaBlockState);
            int n2 = dir.ordinal();
            probMap[n2] = probMap[n2] + treePart.probabilityForBlock(deltaBlockState, (BlockGetter)level, deltaPos, context.branch());
        }
        probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(level, context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(level.m_8055_(context.pos())), probMap));
        int choice = MathHelper.selectRandomFromDistribution((RandomSource)signal.rand, (int[])probMap);
        return this.newDirectionSelected(configuration, context, Direction.values()[choice != -1 ? choice : 1]);
    }

    private Direction newDirectionSelected(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context, Direction newDir) {
        GrowSignal signal = context.signal();
        if (signal.isInTrunk() && newDir != Direction.UP) {
            int signalY = signal.delta.m_123342_();
            if (signalY < configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) {
                signal.energy = 0.9f + (1.0f - (float)signalY / (float)configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) * 3.7f;
            } else {
                signal.energy += 5.0f;
                signal.energy /= 4.8f;
                if (signal.energy > 5.8f) {
                    signal.energy = 5.8f;
                }
            }
        }
        return newDir;
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.m_122424_();
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() || signal.delta.m_123342_() >= configuration.getLowestBranchHeight((PositionalSpeciesContext)context) ? context.species().getUpProbability() : 1;
        probMap[originDir.ordinal()] = 0;
        if (signal.numTurns == 1 && signal.delta.m_123331_(new Vec3i(0, signal.delta.m_123342_(), 0)) == 1.0) {
            probMap[1] = 0;
        }
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        Level level = context.level();
        BlockPos pos = context.pos();
        Species species = context.species();
        return species.getSignalEnergy() * species.biomeSuitability(level, pos) + this.getHashedVariation(level, pos, 2, 16);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        Level level = context.level();
        BlockPos pos = context.pos();
        return (int)(((float)super.getLowestBranchHeight(configuration, context) + this.getHashedVariation(level, pos, 2, 16) * 0.5f) * context.species().biomeSuitability(level, pos));
    }

    private int getHashedVariation(Level level, BlockPos pos, int readyMade) {
        long day = level.m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.m_6630_(month), (int)readyMade);
    }

    private float getHashedVariation(Level level, BlockPos pos, int readyMade, Integer mod) {
        return this.getHashedVariation(level, pos, readyMade) % mod;
    }
}

