/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import org.watermedia.api.math.MathAPI;
import org.watermedia.core.tools.IOTool;

public class Main {
    public static final Logger LOGGER = Logger.getLogger("WaterMedia");
    public static final JFrame window = new JFrame("WATERMeDIA: Diagnosis Tool");
    public static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final ClassLoader classLoader = Main.class.getClassLoader();

    public static void main(String ... args) {
        window.setSize(1280, 720);
        window.setDefaultCloseOperation(3);
        window.setLocationRelativeTo(null);
        window.setIconImage(new ImageIcon(classLoader.getResource("icon.png")).getImage());
        JPanel root = new JPanel(new BorderLayout());
        root.setBackground(new Color(MathAPI.argb(255, 40, 40, 40)));
        JPanel imagePanel = new JPanel(new BorderLayout(10, 0));
        imagePanel.setBackground(new Color(MathAPI.argb(255, 20, 20, 20)));
        JLabel logo = new JLabel();
        logo.setIcon(new ImageIcon(new ImageIcon(classLoader.getResource("banner.png")).getImage().getScaledInstance(600, 100, 2)));
        imagePanel.add((Component)logo, "West");
        root.add((Component)imagePanel, "North");
        JLabel info = new JLabel();
        info.setText("Diagnosis Tool");
        info.setFont(new Font("Default", 1, 24));
        info.setForeground(Color.WHITE);
        info.setBorder(new EmptyBorder(0, 0, 0, 20));
        imagePanel.add((Component)info, "East");
        JTextArea console = new JTextArea();
        console.setEditable(true);
        console.setLineWrap(true);
        console.setWrapStyleWord(true);
        console.setFont(new Font("Monospaced", 0, 14));
        console.setBackground(Color.DARK_GRAY);
        console.setForeground(Color.WHITE);
        console.setMargin(new Insets(5, 5, 5, 5));
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(2);
        caret.setVisible(true);
        console.setCaret(caret);
        JScrollPane scrollPane = new JScrollPane(console);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new ConsoleFormatter(console));
        LOGGER.addHandler(handler);
        LOGGER.setUseParentHandlers(false);
        root.add((Component)scrollPane, "Center");
        JPanel actionsPanel = new JPanel(new FlowLayout(2));
        actionsPanel.setBackground(new Color(MathAPI.argb(255, 20, 20, 20)));
        JButton generateReport = new JButton("Collect Crash Report");
        generateReport.setText("Collect Crash Report");
        generateReport.setBackground(Color.BLACK);
        generateReport.setForeground(Color.WHITE);
        generateReport.setFocusPainted(false);
        generateReport.setMargin(new Insets(15, 25, 15, 25));
        generateReport.setFont(new Font("Default", 0, 16));
        generateReport.addActionListener(e -> {
            for (Component c : actionsPanel.getComponents()) {
                c.setEnabled(false);
            }
            new Thread(() -> {
                Thread t = new CollectionTask().startTask();
                try {
                    t.join();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                long logPrinted = System.currentTimeMillis();
                long targetTime = logPrinted + 10000L;
                int count = 10;
                while (System.currentTimeMillis() < targetTime) {
                    if (logPrinted >= System.currentTimeMillis()) continue;
                    LOGGER.info("Closing in " + count--);
                    logPrinted = System.currentTimeMillis() + 1000L;
                }
                window.dispose();
            }).start();
        });
        JButton diagnosis = new JButton("Diagnosis");
        diagnosis.setBackground(Color.BLACK);
        diagnosis.setForeground(Color.WHITE);
        diagnosis.setFocusPainted(false);
        diagnosis.setMargin(new Insets(15, 25, 15, 25));
        diagnosis.setFont(new Font("Default", 0, 16));
        diagnosis.addActionListener(e -> Main.performDiagnosis());
        actionsPanel.add(diagnosis);
        actionsPanel.add(generateReport);
        root.add((Component)actionsPanel, "South");
        window.add(root);
        window.setVisible(true);
        LOGGER.info("Welcome to the diagnosis tool");
        LOGGER.info("==== Click on any of the options to start ====");
    }

    private static void performDiagnosis() {
        LOGGER.info("Performing diagnosis");
        LOGGER.warning("Diagnosis Failed, Not Implemented Yet!");
    }

    private static void performCollection() {
        LOGGER.info("Looking for data...");
    }

    private static class ConsoleFormatter
    extends Formatter {
        public static final String RESET = "\u001b[0m";
        public static final String RED = "\u001b[31m";
        public static final String GREEN = "\u001b[32m";
        public static final String YELLOW = "\u001b[33m";
        public static final String BLUE = "\u001b[34m";
        public static final String PURPLE = "\u001b[35m";
        JTextArea textArea;

        public ConsoleFormatter(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public String format(LogRecord record) {
            String color = this.getColorLevel(record.getLevel());
            String time = "[" + FORMAT.format(new Date(record.getMillis())) + "]";
            String threadLevel = "[" + Thread.currentThread().getName() + "/" + record.getLevel().toString().substring(0, 4) + "]";
            String loggerMarker = "[" + record.getLoggerName() + "/]";
            String r = time + " " + threadLevel + " " + loggerMarker + ": " + record.getMessage() + (record.getThrown() != null ? record.getThrown().toString() : "") + "\n";
            this.textArea.append(r);
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            return color + r + RESET;
        }

        public String getColorLevel(Level level) {
            if (level.equals(Level.SEVERE)) {
                return RED;
            }
            if (level.equals(Level.WARNING)) {
                return YELLOW;
            }
            if (level.equals(Level.INFO)) {
                return GREEN;
            }
            if (level.equals(Level.CONFIG)) {
                return BLUE;
            }
            if (level.intValue() <= Level.FINE.intValue()) {
                return PURPLE;
            }
            return RESET;
        }
    }

    private static class CollectionTask
    extends Thread {
        private final Path root;
        private final Result result = new Result();

        public CollectionTask() {
            File location = new File("").getAbsoluteFile();
            String locationStr = location.toString();
            LOGGER.info("Running on '" + locationStr + "'");
            LOGGER.info("Checking for '" + File.separator + "mods'");
            if (locationStr.endsWith(File.separator + "mods") || locationStr.endsWith(File.separator + "mods" + File.pathSeparatorChar)) {
                location = location.getParentFile();
                LOGGER.info("Attached to folder '" + location.toString() + "'");
            } else {
                LOGGER.warning("We are running outside mods folder, output might not be the ideal");
            }
            this.root = location.toPath();
        }

        public Thread startTask() {
            this.start();
            return this;
        }

        @Override
        public void run() {
            LOGGER.info("Scanning crash-report folder...");
            Path crashReportFolder = this.root.resolve("crash-reports");
            try {
                Object[] crashReportFiles = crashReportFolder.toFile().listFiles();
                if (crashReportFiles == null || crashReportFiles.length == 0) {
                    throw new NullPointerException("No such directory or is empty");
                }
                Arrays.sort(crashReportFiles, Comparator.comparingLong(File::lastModified));
                File crashReport = crashReportFiles[0];
                LOGGER.info("Collected files: " + Arrays.toString(crashReportFiles));
                this.result.setCrashReport(crashReport);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to get crash-reports files..." + e.getMessage());
            }
            Path logsFolder = this.root.resolve("logs");
            File log = logsFolder.resolve("latest.log").toFile();
            File debug = logsFolder.resolve("debug.log").toFile();
            LOGGER.info("Looking for log file");
            if (log.exists()) {
                this.result.setLog(log);
            } else {
                LOGGER.warning("Log file not found");
            }
            LOGGER.info("Looking for debug file");
            if (debug.exists()) {
                this.result.setDebug(debug);
            } else {
                LOGGER.warning("Debug file not found");
            }
            LOGGER.info("Scanning root folder for hs_err_pidXXX.log files");
            try (Stream<Path> pathStream = Files.walk(this.root, new FileVisitOption[0]);){
                this.result.setHsErrPids((File[])pathStream.filter(path -> path.toString().matches("hs_err_pid[1-9]{1,32}\\.log")).map(Path::toFile).toArray(value -> new File[0]));
            }
            catch (Exception e) {
                LOGGER.warning("Failed to get crash-report files..." + e.getMessage());
            }
            LOGGER.info("Collection finished... generating instructions and upload dir");
            if (!this.result.contains()) {
                LOGGER.warning("Collector didn't find nothing in your instance... cancelling result outdraw");
                return;
            }
            try (InputStream is = Main.class.getClassLoader().getResourceAsStream("watermedia/instructions.txt");){
                File wroot = this.root.resolve("watermedia_diagnosis").toFile().getAbsoluteFile();
                if (wroot.exists()) {
                    IOTool.rmdirs(wroot);
                }
                if (!wroot.exists() && !wroot.mkdirs()) {
                    throw new IOException("Cannot mkdir collected files dir");
                }
                Files.copy(is, wroot.toPath().resolve("instructions.txt"), new CopyOption[0]);
                if (this.result.crashReport != null) {
                    Files.copy(this.result.crashReport.toPath(), wroot.toPath().resolve("crash-report.txt"), new CopyOption[0]);
                }
                if (this.result.log != null) {
                    Files.copy(this.result.log.toPath(), wroot.toPath().resolve("latest.log"), new CopyOption[0]);
                }
                if (this.result.debug != null) {
                    Files.copy(this.result.debug.toPath(), wroot.toPath().resolve("debug.log"), new CopyOption[0]);
                }
                if (this.result.hsErrPids != null) {
                    for (File f : this.result.hsErrPids) {
                        Files.copy(f.toPath(), wroot.toPath().resolve(f.getName()), new CopyOption[0]);
                    }
                }
                Desktop desktop = Desktop.getDesktop();
                desktop.open(wroot);
            }
            catch (Exception e) {
                LOGGER.warning("Failed collecting files: " + e.getMessage());
            }
        }

        public static class Result {
            private File crashReport;
            private File log;
            private File debug;
            private File[] hsErrPids;

            public void setCrashReport(File crashReport) {
                this.crashReport = crashReport;
            }

            public void setDebug(File debug) {
                this.debug = debug;
            }

            public void setLog(File log) {
                this.log = log;
            }

            public void setHsErrPids(File[] hsErrPids) {
                this.hsErrPids = hsErrPids;
            }

            public boolean contains() {
                return this.crashReport != null || this.log != null || this.debug != null || this.hsErrPids != null && this.hsErrPids.length > 0;
            }
        }
    }
}

