/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.fastjson.serializer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.fastjson.JSONObject;
import org.watermedia.shaded.fastjson.parser.DefaultJSONParser;
import org.watermedia.shaded.fastjson.parser.deserializer.ObjectDeserializer;
import org.watermedia.shaded.fastjson.serializer.JSONSerializer;
import org.watermedia.shaded.fastjson.serializer.ObjectSerializer;
import org.watermedia.shaded.fastjson.serializer.SerializeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuavaCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static GuavaCodec instance = new GuavaCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object instanceof Multimap) {
            Multimap multimap = (Multimap)object;
            serializer.write(multimap.asMap());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Type rawType = type;
        if (type instanceof ParameterizedType) {
            rawType = ((ParameterizedType)type).getRawType();
        }
        if (rawType == ArrayListMultimap.class) {
            ArrayListMultimap multimap = ArrayListMultimap.create();
            JSONObject object = parser.parseObject();
            for (Map.Entry<String, Object> entry : object.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    multimap.putAll((Object)entry.getKey(), (Iterable)((List)value));
                    continue;
                }
                multimap.put((Object)entry.getKey(), value);
            }
            return (T)multimap;
        }
        return null;
    }

    @Override
    public int getFastMatchToken() {
        return 0;
    }
}

