/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.weido.create_bb.data.compat.steamnrails.MenuSwitchButton;
import com.weido.create_bb.data.menu.BogeyStyleMenuState;
import com.weido.create_bb.data.menu.Entry.StyleEntry;
import com.weido.create_bb.data.menu.Entry.StyleEntryManager;
import com.weido.create_bb.data.menu.Input.AxleCountScrollInput;
import com.weido.create_bb.data.menu.Input.LengthScrollInput;
import com.weido.create_bb.data.menu.Input.SizeScrollInput;
import com.weido.create_bb.data.menu.Input.SpeedScrollInput;
import com.weido.create_bb.data.menu.Input.TypeButton;
import com.weido.create_bb.data.menu.Input.ValveGearScrollInput;
import com.weido.create_bb.data.menu.Input.VariantScrollInput;
import com.weido.create_bb.data.packets.BogieStylePacket;
import com.weido.create_bb.registry.BlocksBogiesGuiTextures;
import com.weido.create_bb.registry.BogiePackets;
import java.util.Set;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class BogieStyleSelectionScreen
extends AbstractSimiScreen {
    private final BlocksBogiesGuiTextures background = BlocksBogiesGuiTextures.BOGIE_MENU;
    @Nullable
    private BlockPos targetPos;
    private static final float MIN_SCALE = 10.0f;
    private static final float MAX_SCALE = 96.0f;
    private static boolean firstTime = true;
    private boolean isDragging = false;
    private boolean isMoving = false;
    private int previewX;
    private int previewY;
    private float previewOffsetX = 0.0f;
    private float previewOffsetY = 0.0f;
    private float previewScale = 26.0f;
    private float rotationX = -20.0f;
    private float rotationY = 45.0f;
    private float totalRotationY = 45.0f;
    private float wheelAngle = 0.0f;
    private float prevWheelAngle = 0.0f;
    private double lastMouseX;
    private double lastMouseY;
    private TypeButton typeButton;
    private ScrollInput variantScroll;
    private ScrollInput valvegearScroll;
    private ScrollInput axleCountScroll;
    private ScrollInput speedScroll;
    private ScrollInput sizeScroll;
    private ScrollInput lengthScroll;
    private StyleEntry.Type currentType = StyleEntry.Type.TRUCK;
    int previewPosRight = 299;
    int previewPosBottom = 211;
    int previewWidth = 296;
    int previewHeight = 129;
    StyleEntry selectedBogie;

    public BogieStyleSelectionScreen(@Nullable BlockPos pos) {
        this.targetPos = pos;
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.m_7856_();
        this.previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
        this.previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
        this.currentType = firstTime ? StyleEntry.Type.TRUCK : BogeyStyleMenuState.getLastType();
        int buttonHeight = 18;
        int buttonLeftPos = this.guiLeft + 7;
        int buttonRightPos = this.guiLeft + this.background.getWidth() - 149;
        int buttonTopPos = this.guiTop + this.background.getHeight() - 75;
        int buttonBottomPos = this.guiTop + this.background.getHeight() - 53;
        IconButton confirmButton = (IconButton)new IconButton(this.guiLeft + this.background.getWidth() - 25, this.guiTop + this.background.getHeight() - 24, (ScreenElement)AllIcons.I_CONFIRM).withCallback(this::m_7379_);
        if (ModList.get().isLoaded("railways")) {
            this.m_142416_((GuiEventListener)MenuSwitchButton.create(this.guiLeft + this.background.getWidth() - 54, this.guiTop + this.background.getHeight() - 24, this.targetPos, this::onMenuSwitch));
        }
        this.typeButton = (TypeButton)new TypeButton(buttonRightPos, buttonBottomPos).withCallback(() -> {
            this.currentType = this.currentType == StyleEntry.Type.TRUCK ? StyleEntry.Type.DRIVER : StyleEntry.Type.TRUCK;
            this.updateValidOptions();
            this.updateSelectedBogey();
            this.updateSizeSelection();
        });
        this.variantScroll = new VariantScrollInput(buttonLeftPos, buttonTopPos, 142, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastVariant());
        this.valvegearScroll = new ValveGearScrollInput(buttonRightPos, buttonTopPos, 142, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastValvegear());
        this.axleCountScroll = new AxleCountScrollInput(buttonLeftPos, buttonBottomPos, 78, buttonHeight).setState(firstTime ? 2 : BogeyStyleMenuState.getLastAxleCount());
        this.sizeScroll = new SizeScrollInput(this.guiLeft + this.background.getWidth() - 58, buttonBottomPos, 51, buttonHeight);
        this.lengthScroll = new LengthScrollInput(this.guiLeft + this.background.getWidth() - 213, buttonBottomPos, 60, buttonHeight).setState(firstTime ? 0 : BogeyStyleMenuState.getLastBogieLength());
        this.speedScroll = new SpeedScrollInput(buttonLeftPos - 1, this.guiTop + 127, 31, 15).setState(5);
        this.m_142416_((GuiEventListener)confirmButton);
        this.m_142416_((GuiEventListener)this.typeButton);
        this.m_142416_((GuiEventListener)this.variantScroll);
        this.m_142416_((GuiEventListener)this.valvegearScroll);
        this.m_142416_((GuiEventListener)this.axleCountScroll);
        this.m_142416_((GuiEventListener)this.speedScroll);
        this.m_142416_((GuiEventListener)this.sizeScroll);
        this.m_142416_((GuiEventListener)this.lengthScroll);
        this.updateValidOptions();
        this.updateSelectedBogey();
        this.setupScrollCallbacks();
        this.updateSizeSelection();
        this.sizeScroll.setState(firstTime ? 1 : BogeyStyleMenuState.getLastSize());
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        this.background.render(graphics, this.guiLeft, this.guiTop);
    }

    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedBogie != null && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            int previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
            int previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
            graphics.m_280588_(previewX, previewY, previewX + this.previewWidth, previewY + this.previewHeight);
            this.renderModelPreview(graphics, partialTicks);
            graphics.m_280618_();
        }
        BlocksBogiesGuiTextures.NUMBER_BACKGROUND.render(graphics, this.speedScroll.m_252754_(), this.speedScroll.m_252907_());
    }

    public void renderWindowForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        MutableComponent title = Component.m_237115_((String)"create_bb.menu.title");
        int titleX = this.guiLeft + this.background.getWidth() / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2;
        int titleY = this.guiTop + 4;
        graphics.m_280614_(this.f_96547_, (Component)title, titleX, titleY, 5841956, false);
        this.renderAllText(graphics);
    }

    public void m_86600_() {
        super.m_86600_();
        this.prevWheelAngle = this.wheelAngle;
        this.wheelAngle = (this.wheelAngle + (float)(-this.speedScroll.getState())) % 360.0f;
    }

    public void m_7379_() {
        firstTime = false;
        this.saveMenuState();
        this.sendMenuPacket();
        super.m_7379_();
        this.targetPos = null;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int speedX = this.speedScroll.m_252754_();
        int speedY = this.speedScroll.m_252907_();
        int numberWidth = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getWidth();
        int numberHeight = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getHeight();
        if (mouseX >= (double)speedX && mouseX <= (double)(speedX + numberWidth) && mouseY >= (double)speedY && mouseY <= (double)(speedY + numberHeight)) {
            return this.speedScroll.m_6050_(mouseX, mouseY, delta);
        }
        int previewX = this.guiLeft + this.background.getWidth() - this.previewPosRight;
        int previewY = this.guiTop + this.background.getHeight() - this.previewPosBottom;
        if (mouseX >= (double)previewX && mouseX <= (double)(previewX + this.previewWidth) && mouseY >= (double)previewY && mouseY <= (double)(previewY + this.previewHeight)) {
            this.previewScale = (float)Mth.m_14008_((double)((double)this.previewScale + delta * 2.0), (double)10.0, (double)96.0);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.previewX && mouseX <= (double)(this.previewX + this.previewWidth) && mouseY >= (double)this.previewY && mouseY <= (double)(this.previewY + this.previewHeight)) {
            if (button == 0) {
                this.isDragging = true;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            } else if (button == 1) {
                this.isMoving = true;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
            if (this.f_96541_ != null) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212994);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging || this.isMoving) {
            if (this.f_96541_ != null) {
                double scaleFactor = this.f_96541_.m_91268_().m_85449_();
                double centerX = ((double)this.previewX + (double)this.previewWidth / 2.0) * scaleFactor;
                double centerY = ((double)this.previewY + (double)this.previewHeight / 2.0) * scaleFactor;
                if (this.isDragging) {
                    float deltaX = (float)((mouseX - this.lastMouseX) * 0.5);
                    float deltaY = (float)((mouseY - this.lastMouseY) * 0.5);
                    if (BogieStyleSelectionScreen.m_96638_()) {
                        this.totalRotationY += deltaX;
                        this.rotationY = (float)Math.round(this.totalRotationY / 90.0f) * 90.0f;
                        this.rotationX = 0.0f;
                    } else {
                        this.totalRotationY += deltaX;
                        this.rotationY = this.totalRotationY % 360.0f;
                        this.rotationX = Mth.m_14036_((float)(this.rotationX - deltaY), (float)-22.5f, (float)22.5f);
                    }
                } else {
                    this.previewOffsetX += (float)(mouseX - this.lastMouseX);
                    this.previewOffsetY += (float)(mouseY - this.lastMouseY);
                }
                GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)centerX, (double)centerY);
                this.lastMouseX = centerX / scaleFactor;
                this.lastMouseY = centerY / scaleFactor;
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDragging || this.isMoving) {
            this.isDragging = false;
            this.isMoving = false;
            if (this.f_96541_ != null) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateValidOptions() {
        Set<StyleEntry.ValveGear> validValveGears;
        if (this.currentType == StyleEntry.Type.TRUCK) {
            validValveGears = Set.of(StyleEntry.ValveGear.NONE);
            this.valvegearScroll.setState(0);
        } else {
            validValveGears = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == StyleEntry.Type.DRIVER).map(StyleEntry::valveGear).collect(Collectors.toSet());
        }
        ((ValveGearScrollInput)this.valvegearScroll).updateOptions(validValveGears);
        StyleEntry.ValveGear currentValveGear = ((ValveGearScrollInput)this.valvegearScroll).valveGears[this.valvegearScroll.getState()];
        Set<StyleEntry.Variant> validVariants = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.valveGear() == currentValveGear).map(StyleEntry::variant).collect(Collectors.toSet());
        ((VariantScrollInput)this.variantScroll).updateOptions(validVariants);
        StyleEntry.Variant variant = ((VariantScrollInput)this.variantScroll).variants[this.variantScroll.getState()];
        if (!validVariants.contains((Object)variant)) {
            this.variantScroll.setState(0);
            variant = ((VariantScrollInput)this.variantScroll).variants[0];
        }
        StyleEntry.Variant currentVariant = variant;
        Set validAxleCounts = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).map(StyleEntry::axleCount).collect(Collectors.toSet());
        int minAxles = validAxleCounts.stream().min(Integer::compareTo).orElse(2);
        int maxAxles = validAxleCounts.stream().max(Integer::compareTo).orElse(2);
        ((AxleCountScrollInput)this.axleCountScroll).updateOptions(minAxles, maxAxles);
        int currentAxleCount = this.axleCountScroll.getState();
        Set<BogeySizes.BogeySize> validSizes = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).filter(entry -> entry.axleCount() == currentAxleCount).flatMap(entry -> entry.bogeyStyle().validSizes().stream()).collect(Collectors.toSet());
        BogeySizes.BogeySize currentSize = ((SizeScrollInput)this.sizeScroll).getCurrentSize();
        ((SizeScrollInput)this.sizeScroll).updateOptions(validSizes);
        if (!validSizes.contains(currentSize)) {
            BogeySizes.BogeySize fallbackSize = validSizes.stream().findFirst().orElse(BogeySizes.SMALL);
            this.sizeScroll.setState(validSizes.stream().toList().indexOf(fallbackSize));
        } else {
            this.sizeScroll.setState(validSizes.stream().toList().indexOf(currentSize));
        }
        Set<StyleEntry.Length> validLengths = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.type() == this.currentType).filter(entry -> entry.variant() == currentVariant).filter(entry -> entry.valveGear() == currentValveGear).filter(entry -> entry.axleCount() == currentAxleCount).map(StyleEntry::length).collect(Collectors.toSet());
        ((LengthScrollInput)this.lengthScroll).updateOptions(validLengths);
        StyleEntry.Length currentLength = ((LengthScrollInput)this.lengthScroll).bogieLength[this.lengthScroll.getState()];
        if (!validLengths.contains((Object)currentLength)) {
            this.lengthScroll.setState(0);
        }
        this.updateSelectedBogey();
    }

    private void updateSelectedBogey() {
        VariantScrollInput variantInput = (VariantScrollInput)this.variantScroll;
        ValveGearScrollInput valveGearInput = (ValveGearScrollInput)this.valvegearScroll;
        LengthScrollInput lengthInput = (LengthScrollInput)this.lengthScroll;
        StyleEntry.Variant variant = variantInput.variants[this.variantScroll.getState()];
        StyleEntry.ValveGear valveGear = valveGearInput.valveGears[this.valvegearScroll.getState()];
        StyleEntry.Length length = lengthInput.bogieLength[this.lengthScroll.getState()];
        int axleCount = this.axleCountScroll.getState();
        this.selectedBogie = StyleEntryManager.getBogeyEntryList().stream().filter(entry -> entry.variant() == variant && entry.valveGear() == valveGear && entry.type() == this.currentType && entry.axleCount() == axleCount && entry.length() == length).findFirst().orElseGet(() -> StyleEntry.getOrCreate(AllBogeyStyles.STANDARD, variant, valveGear, this.currentType, axleCount, length));
    }

    private void renderButtonText(GuiGraphics graphics, TypeButton button, Component text) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        int buttonX = button.m_252754_();
        int buttonY = button.m_252907_();
        graphics.m_280614_(this.f_96547_, text, buttonX + (button.m_5711_() - textWidth) / 2, buttonY + 5, 0xFFFFFF, true);
    }

    private void renderScrollText(GuiGraphics graphics, ScrollInput scroll, Component text) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        int scrollX = scroll.m_252754_();
        int scrollY = scroll.m_252907_();
        graphics.m_280614_(this.f_96547_, text, scrollX + (scroll.m_5711_() - textWidth) / 2 + 1, scrollY + 5, 0xFFFFFF, true);
    }

    private void renderScrollNumber(GuiGraphics graphics, ScrollInput scroll, Component text) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        int scrollX = scroll.m_252754_();
        int scrollY = scroll.m_252907_();
        graphics.m_280614_(this.f_96547_, text, scrollX + 1 + (scroll.m_5711_() - textWidth) / 2, scrollY + 4, 5841956, false);
    }

    private void renderModelPreview(GuiGraphics graphics, float partialTicks) {
        int speedX = this.speedScroll.m_252754_();
        int speedY = this.speedScroll.m_252907_();
        int numberWidth = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getWidth();
        int numberHeight = BlocksBogiesGuiTextures.NUMBER_BACKGROUND.getHeight();
        graphics.m_280588_(this.previewX, this.previewY, speedX + 1, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.m_280618_();
        graphics.m_280588_(speedX + numberWidth - 1, this.previewY, this.previewX + this.previewWidth, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.m_280618_();
        graphics.m_280588_(speedX, this.previewY, speedX + numberWidth, speedY + 1);
        this.renderModel(graphics, partialTicks);
        graphics.m_280618_();
        graphics.m_280588_(speedX, speedY + numberHeight - 1, speedX + numberWidth, this.previewY + this.previewHeight);
        this.renderModel(graphics, partialTicks);
        graphics.m_280618_();
    }

    private void renderModel(GuiGraphics graphics, float partialTicks) {
        if (this.selectedBogie == null || this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        int backgroundWidth = this.background.getWidth();
        BogeyStyle style = this.selectedBogie.bogeyStyle();
        BogeySizes.BogeySize renderSize = ((SizeScrollInput)this.sizeScroll).getCurrentSize();
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252880_((float)this.guiLeft + (float)backgroundWidth / 2.0f + this.previewOffsetX, (float)(this.guiTop + this.background.getHeight() - 151) + this.previewOffsetY, 1500.0f);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        ms.m_252880_(0.0f, 0.0f, 1000.0f);
        ms.m_85841_(this.previewScale, this.previewScale, this.previewScale);
        ms.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ms.m_252781_(Axis.f_252529_.m_252977_(this.rotationX));
        ms.m_252781_(Axis.f_252436_.m_252977_(this.rotationY));
        Lighting.m_166384_();
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        int light = 0xF000F0;
        int overlay = OverlayTexture.f_118083_;
        float interpolatedAngle = this.lerpAngle(partialTicks, this.prevWheelAngle, this.wheelAngle);
        BlockState bogeyState = (BlockState)style.getBlockForSize(renderSize).m_49966_().m_61124_((Property)AbstractBogeyBlock.AXIS, (Comparable)Direction.Axis.Z);
        ((SuperByteBuffer)CachedBuffers.block((BlockState)bogeyState).translate(-0.5f, -0.5f, -0.5f)).light(light).overlay(overlay).renderInto(ms, bufferSource.m_6299_(RenderType.m_110457_()));
        style.render(renderSize, partialTicks, ms, (MultiBufferSource)bufferSource, light, overlay, interpolatedAngle, null, false);
        bufferSource.m_109911_();
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        ms.m_85849_();
        RenderSystem.clear((int)256, (boolean)false);
    }

    private void renderAllText(GuiGraphics graphics) {
        VariantScrollInput variantInput = (VariantScrollInput)this.variantScroll;
        ValveGearScrollInput valveGearInput = (ValveGearScrollInput)this.valvegearScroll;
        LengthScrollInput lengthInput = (LengthScrollInput)this.lengthScroll;
        MutableComponent typeText = Component.m_237115_((String)"create_bb.menu.type").m_7220_(this.currentType.getDisplayText());
        this.renderButtonText(graphics, this.typeButton, (Component)typeText);
        MutableComponent variantText = Component.m_237115_((String)"create_bb.menu.variant").m_7220_(variantInput.variants[this.variantScroll.getState()].getDisplayText());
        this.renderScrollText(graphics, this.variantScroll, (Component)variantText);
        this.disabledScroll(graphics, this.variantScroll, variantInput.variants.length);
        MutableComponent valveGearText = Component.m_237115_((String)"create_bb.menu.valve_gear").m_7220_(valveGearInput.valveGears[this.valvegearScroll.getState()].getDisplayText());
        this.renderScrollText(graphics, this.valvegearScroll, (Component)valveGearText);
        this.disabledScroll(graphics, this.valvegearScroll, valveGearInput.valveGears.length);
        MutableComponent axleText = Component.m_237115_((String)"create_bb.menu.axle_count").m_130946_(String.valueOf(this.axleCountScroll.getState()));
        this.renderScrollText(graphics, this.axleCountScroll, (Component)axleText);
        this.disabledScroll(graphics, this.axleCountScroll, ((AxleCountScrollInput)this.axleCountScroll).getMaxAxles() == ((AxleCountScrollInput)this.axleCountScroll).getMinAxles() ? 1 : 0);
        MutableComponent speedText = Component.m_237113_((String)String.valueOf(this.speedScroll.getState()));
        this.renderScrollNumber(graphics, this.speedScroll, (Component)speedText);
        String sizeKey = ((SizeScrollInput)this.sizeScroll).getCurrentSize() == BogeySizes.LARGE ? (this.currentType == StyleEntry.Type.DRIVER ? "create_bb.menu.size.extra_large" : "create_bb.menu.size.large") : (this.currentType == StyleEntry.Type.DRIVER ? "create_bb.menu.size.large" : "create_bb.menu.size.small");
        MutableComponent sizeText = Component.m_237115_((String)sizeKey);
        this.renderScrollText(graphics, this.sizeScroll, (Component)sizeText);
        this.disabledScroll(graphics, this.sizeScroll, ((SizeScrollInput)this.sizeScroll).getSizes().length);
        Component lengthText = lengthInput.bogieLength[this.lengthScroll.getState()].getDisplayText();
        this.renderScrollText(graphics, this.lengthScroll, lengthText);
        this.disabledScroll(graphics, this.lengthScroll, lengthInput.bogieLength.length);
    }

    private void disabledScroll(GuiGraphics graphics, ScrollInput scrollInput, int optionsLength) {
        if (optionsLength == 1) {
            graphics.m_280509_(scrollInput.m_252754_(), scrollInput.m_252907_(), scrollInput.m_252754_() + scrollInput.m_5711_(), scrollInput.m_252907_() + scrollInput.m_93694_(), -2144128205);
        }
    }

    private void setupScrollCallbacks() {
        ScrollInput[] scrolls;
        for (ScrollInput scroll : scrolls = new ScrollInput[]{this.variantScroll, this.valvegearScroll, this.axleCountScroll, this.sizeScroll, this.lengthScroll}) {
            scroll.calling(state -> {
                this.updateSelectedBogey();
                this.updateValidOptions();
            });
        }
    }

    private void updateSizeSelection() {
        ((SizeScrollInput)this.sizeScroll).setDriver(this.currentType == StyleEntry.Type.DRIVER);
    }

    public void onMenuSwitch() {
        firstTime = false;
        this.saveMenuState();
    }

    public void sendMenuPacket() {
        BogieStylePacket packet = new BogieStylePacket(this.selectedBogie.bogeyStyle(), ((SizeScrollInput)this.sizeScroll).getCurrentSize(), this.targetPos);
        BogiePackets.getChannel().sendToServer((Object)packet);
    }

    public void saveMenuState() {
        BogeyStyleMenuState.saveState(this.currentType, this.variantScroll.getState(), this.valvegearScroll.getState(), this.axleCountScroll.getState(), this.sizeScroll.getState(), this.lengthScroll.getState());
    }

    private float lerpAngle(float partialTicks, float start, float end) {
        float delta = (end - start + 540.0f) % 360.0f - 180.0f;
        return start + delta * partialTicks;
    }
}

