/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.visuals.trailing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import com.weido.create_bb.registry.BogiePartials;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class SingleAxleTrailingVisual
implements BogeyVisual {
    public SingleAxleTrailingVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
    }

    public void hide() {
    }

    public void updateLight(int packedLight) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public void delete() {
    }

    public static class SingleAxleSmallTrailing
    extends SingleAxleTrailingVisual {
        public final TransformedInstance frame;
        public final TransformedInstance shaft1;
        public final TransformedInstance shaft2;
        public final TransformedInstance shaft3;
        public final TransformedInstance wheel1;

        public SingleAxleSmallTrailing(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)BogiePartials.SMALL_TRAILING_2_FRAME)).createInstance();
            Instancer shaftInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT));
            Instancer wheelInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)BogiePartials.SMALL_SHARED_WHEELS));
            this.shaft1 = (TransformedInstance)shaftInstancer.createInstance();
            this.shaft2 = (TransformedInstance)shaftInstancer.createInstance();
            this.shaft3 = (TransformedInstance)shaftInstancer.createInstance();
            this.wheel1 = (TransformedInstance)wheelInstancer.createInstance();
        }

        @Override
        public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
            ((TransformedInstance)this.frame.setTransform(poseStack).scale(0.9980469f)).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft1.setTransform(poseStack).translate(-0.5f, 0.25f, 0.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft2.setTransform(poseStack).translate(-0.5f, 0.25f, -1.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft3.setTransform(poseStack).translate(-0.5f, 0.25f, -0.5f).center()).rotateTo(Direction.UP, Direction.EAST)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)this.wheel1.setTransform(poseStack).translate(0.0f, 0.75f, 0.0f).rotateXDegrees(wheelAngle)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.frame.setZeroTransform().setChanged();
            this.shaft1.setZeroTransform().setChanged();
            this.shaft2.setZeroTransform().setChanged();
            this.shaft3.setZeroTransform().setChanged();
            this.wheel1.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            this.frame.light(packedLight).setChanged();
            this.shaft1.light(packedLight).setChanged();
            this.shaft2.light(packedLight).setChanged();
            this.shaft3.light(packedLight).setChanged();
            this.wheel1.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.frame);
            consumer.accept((Instance)this.shaft1);
            consumer.accept((Instance)this.shaft2);
            consumer.accept((Instance)this.shaft3);
            consumer.accept((Instance)this.wheel1);
        }

        @Override
        public void delete() {
            super.delete();
            this.frame.delete();
            this.shaft1.delete();
            this.shaft2.delete();
            this.shaft3.delete();
            this.wheel1.delete();
        }
    }
}

